;====================================================================
function minmax,array,subs,NAN=nan, DIMEN=dimen
 On_error,2
 compile_opt idl2
 if N_elements(DIMEN) GT 0 then begin
      amin = min(array, MAX = amax, NAN = nan, DIMEN = dimen,cmin,sub=cmax) 
      if arg_present(subs) then subs = transpose([[cmin], [cmax]])
      return, transpose([[amin],[amax] ])
 endif else  begin 
     amin = min( array, MAX = amax, NAN=nan, cmin, sub=cmax)
      if arg_present(subs) then subs = [cmin, cmax]
     return, [ amin, amax ]
 endelse
 end
;====================================================================
function transf4star_shape,incl,phi,p,xx
;
; Coordinate transformation
;
  a=dblarr(3,3)
  TORAD=!DPI/180
  COSI=  COS(incl*TORAD) & SINI=  SIN(incl*TORAD)
  COSPHI=COS(phi*TORAD)  & SINPHI=SIN(phi*TORAD)
  COSP=  COS(p*TORAD)    & SINP=  SIN(p*TORAD)
  a=[[COSPHI,-SINPHI, 0.D0], $
     [SINPHI, COSPHI, 0.D0], $
     [  0.D0,   0.D0, 1.D0]]
  b=[[1.d0, 0.d0, 0.d0], $
     [0.d0, COSI,-SINI], $
     [0.d0, SINI, COSI]]
  c=[[COSP, 0.D0,-SINP], $
     [0.D0, 1.D0, 0.D0], $
     [SINP, 0.D0, COSP]]
  s=size(xx)
  if(s(0) lt 3) then begin
    x=a#xx & x=b#x & x=c#x
  endif else if(s(0) eq 3) then begin
    n=s(2) & m=s(3)
    x=a#xx & x=b#x & x=c#x
    x=dblarr(3,n,m)
    for j=0,m-1 do x(*,*,j)=a#xx(*,*,j)
    for j=0,m-1 do x(*,*,j)=b# x(*,*,j)
    for j=0,m-1 do x(*,*,j)=c# x(*,*,j)
  endif else if(s(0) eq 4) then begin
    n=s(2) & m=s(3) & k=s(4)
    x=dblarr(3,n,m,k)
    for l=0,k-1 do for j=0,m-1 do x(*,*,j,l)=a#xx(*,*,j,l)
    for l=0,k-1 do for j=0,m-1 do x(*,*,j,l)=b# x(*,*,j,l)
    for l=0,k-1 do for j=0,m-1 do x(*,*,j,l)=c# x(*,*,j,l)
  endif
  return,x
end

;====================================================================
function triangle,x,y,nx,ny
  k=sort(y)
  x1=x(k(0)) & x2=x(k(1)) & x3=x(k(2))
  y1=y(k(0)) & y2=y(k(1)) & y3=y(k(2))
  n=(floor(y3)-floor(y1))*(floor(max(x))-floor(min(x)))
  if(n le 0) then return,-1
  a31=(x1-x3)/(y1-y3)
  ii=lonarr(2*n)
  n=0
  if(x2 gt (y2-y3)*a31+x3) then begin
    if(floor(y1) lt floor(y2)) then begin
      a12=(x2-x1)/(y2-y1)
      for i=ceil(y1),floor(y2) do begin
        l1=ceil((i-y3)*a31+x3) & l2=floor((i-y1)*a12+x1)
        n12=l2-l1
        if(n12 ge 0) then begin
          ii(n:n+n12)=i*nx+l1+lindgen(n12+1)
          n=n+n12+1
        endif
      endfor
    endif
    if(floor(y2) lt floor(y3)) then begin
      a23=(x3-x2)/(y3-y2)
      for i=ceil(y2),floor(y3) do begin
        l1=ceil((i-y3)*a31+x3) & l2=floor((i-y2)*a23+x2)
        n23=l2-l1
        if(n23 ge 0) then begin
          ii(n:n+n23)=i*nx+l1+lindgen(n23+1)
          n=n+n23+1
        endif
      endfor
    endif
  endif else begin
    if(floor(y1) lt floor(y2)) then begin
      a12=(x2-x1)/(y2-y1)
      for i=ceil(y1),floor(y2) do begin
        l1=ceil((i-y1)*a12+x1) & l2=floor((i-y3)*a31+x3)
        n12=l2-l1
        if(n12 ge 0) then begin
          ii(n:n+n12)=i*nx+l1+lindgen(n12+1)
          n=n+n12+1
        endif
      endfor
    endif
    if(floor(y2) lt floor(y3)) then begin
      a23=(x3-x2)/(y3-y2)
      for i=ceil(y2),floor(y3) do begin
        l1=ceil((i-y2)*a23+x2) & l2=floor((i-y3)*a31+x3)
        n23=l2-l1
        if(n23 ge 0) then begin
          ii(n:n+n23)=i*nx+l1+lindgen(n23+1)
          n=n+n23+1
        endif
      endfor
    endif
  endelse
  if(n le 0) then return,-1
  return,ii(0:n-1)
end

;====================================================================
function star_shape,n,m,alpha,beta,xx,nbox_x,nbox_y,light,background=background
;
; Shared library
;
;   RENDER=!libs_dir+'triangle.so'+!libs_ext
   usepro=1
;
; Setup object
;
if not keyword_set(background) then background=!p.background
img=bytarr(nbox_x,nbox_y)+background
pointer=lonarr(nbox_x,nbox_y)
x=transf4star_shape(alpha,beta,0,xx)
x(0,*,*)=(x(0,*,*)+1)*nbox_x/2
x(1,*,*)=(x(1,*,*)+1)*nbox_x/2+(nbox_y-nbox_x)*0.5
x(2,*,*)=x(2,*,*)*nbox_x/2
;
; Store polygons and normals
;
xxa=dblarr(n-1,m-1,3) & for i=0,2 do xxa(*,*,i)=x(i,1:n-1,0:m-2)
xxb=dblarr(n-1,m-1,3) & for i=0,2 do xxb(*,*,i)=x(i,0:n-2,0:m-2)
xxc=dblarr(n-1,m-1,3) & for i=0,2 do xxc(*,*,i)=x(i,1:n-1,1:m-1)
xxd=dblarr(n-1,m-1,3) & for i=0,2 do xxd(*,*,i)=x(i,0:n-2,1:m-1)
d1=xxa-xxb & d2=xxc-xxb
dx1=d1(*,*,1)*d2(*,*,2)-d2(*,*,1)*d1(*,*,2)
dy1=d1(*,*,2)*d2(*,*,0)-d2(*,*,2)*d1(*,*,0)
dz1=d1(*,*,0)*d2(*,*,1)-d2(*,*,0)*d1(*,*,1)
norm1=sqrt(dx1*dx1+dy1*dy1+dz1*dz1)
d1=xxd-xxb
dx2=d2(*,*,1)*d1(*,*,2)-d1(*,*,1)*d2(*,*,2)
dy2=d2(*,*,2)*d1(*,*,0)-d1(*,*,2)*d2(*,*,0)
dz2=d2(*,*,0)*d1(*,*,1)-d1(*,*,0)*d2(*,*,1)
norm2=sqrt(dx2*dx2+dy2*dy2+dz2*dz2)
ii=where((dz1 lt 0) or (dz2 lt 0), ll)
kk1=where(norm1(ii) eq 0,nkk1)
kk2=where(norm2(ii) eq 0,nkk2)
if(nkk1 gt 0) then norm1(ii(kk1))=1
if(nkk2 gt 0) then norm2(ii(kk2))=1
nr=dblarr(ll,2,3)
nr(*,0,0)=dx1(ii)/norm1(ii) & nr(*,1,0)=dx2(ii)/norm2(ii)
nr(*,0,1)=dy1(ii)/norm1(ii) & nr(*,1,1)=dy2(ii)/norm2(ii)
nr(*,0,2)=dz1(ii)/norm1(ii) & nr(*,1,2)=dz2(ii)/norm2(ii)
if(nkk1 gt 0) then nr(kk1,0,*)=nr(kk1,1,*)
if(nkk2 gt 0) then nr(kk2,1,*)=nr(kk2,0,*)
pl=dblarr(ll,3,4)
for i=0,2 do begin
  di=long(i)*long(n-1)*long(m-1)
  pl(*,i,0)=xxa(ii+di)
  pl(*,i,1)=xxb(ii+di)
  pl(*,i,2)=xxc(ii+di)
  pl(*,i,3)=xxd(ii+di)
endfor
color=light(ii)
ll=ll-1
;clrmax=min([253,!d.n_colors-1])-3
;clrmin=60
;k=reverse(sort(pl(*,2,0)))
; this ensures sorting of polygons in ascending z
k=sort(total(pl(*,2,*),3)/4.)
max_n=10000L
indd=lonarr(max_n)
for j=0L,ll do begin
  l=k(j)
;  clr=fix(acos(total(nr(l,0,*)*light))/!DPI*(clrmax-clrmin))+clrmin
  clr=color(l)
  if(nr(l,0,2) lt 0) then begin
   if(usepro) then begin
    ind=triangle(pl(l,0,0:2),pl(l,1,0:2),nbox_x,nbox_y)
    if((size(ind))(0) gt 0) then begin
      img(ind)=clr & pointer(ind)=l
    endif
   endif else begin
    nn=CALL_EXTERNAL(RENDER,'triangle',pl(l,0,0:2),pl(l,1,0:2), $
                    nbox_x, max_n, indd)
;                     nbox_x, max_n, indd, Value = [0B, 0B, 1B, 1B, 0B])
    if(nn gt 0) then begin
      img(indd(0:nn-1))=clr & pointer(indd(0:nn-1))=l
    endif
   endelse
  endif
;  clr=fix(acos(total(nr(l,1,*)*light))/!DPI*(clrmax-clrmin))+clrmin
  clr=color(l)
  if(nr(l,1,2) lt 0) then begin
   if(usepro) then begin
    ind=triangle(pl(l,0,1:3),pl(l,1,1:3),nbox_x,nbox_y)
    if((size(ind))(0) gt 0) then begin
      img(ind)=clr & pointer(ind)=l
    endif
   endif else begin
    nn=CALL_EXTERNAL(RENDER,'triangle',pl(l,0,1:3),pl(l,1,1:3), $
                     nbox_x, max_n, indd)
;                     nbox_x, max_n, indd, Value = [0B, 0B, 1B, 1B, 0B])
    if(nn gt 0) then begin
      img(indd(0:nn-1))=clr & pointer(indd(0:nn-1))=l
    endif
   endelse
  endif
endfor 
return,img 
end

;====================================================================
pro loadctrb,silent=silent,show=show,alpha=alpha,bw=bw

COMMON COLORS, R_orig, G_orig, B_orig, R_curr, G_curr, B_curr  

ind=0
loadct,ind,silent=silent
if not keyword_set(silent) then begin
  print,'Loading red-blue color table'
  print,'Overwriting table no.',ind
endif

n=keyword_set(bw) ? 256-2 : 256
x=dindgen(n)

rmax=255 & rmin=0
gmax=255 & gmin=0
bmax=255 & bmin=0

r_curr=interpol([rmin,rmax,rmax],[0,n/2,n-1],x)
g_curr=interpol([gmin,gmax,gmin],[0,n/2,n-1],x)
b_curr=interpol([bmax,bmax,bmin],[0,n/2,n-1],x)

if keyword_set(alpha) then begin
  r_curr=255.-rmax*(((255.-r_curr)/rmax)^alpha)
  g_curr=255.-gmax*(((255.-g_curr)/gmax)^alpha)
  b_curr=255.-bmax*(((255.-b_curr)/bmax)^alpha)
endif

sc=1.
r_curr=r_curr*sc
g_curr=g_curr*sc
b_curr=b_curr*sc

if keyword_set(bw) then begin
  r_curr=[0.,r_curr,255.]
  g_curr=[0.,g_curr,255.]
  b_curr=[0.,b_curr,255.]
endif

tvlct,byte(r_curr),byte(g_curr),byte(b_curr)

if not keyword_set(show) then return

!p.multi=[0,1,4] 
!p.charsize=1.5
plot,r_orig,xs=3,ys=3
oplot,r_curr,line=2
plot,g_orig,xs=3,ys=3
oplot,g_curr,line=2
plot,b_orig,xs=3,ys=3
oplot,b_curr,line=2

polyfill,[0,400,400,0,0],[0,0,140,140,0],col=128,/dev
ss=replicate(1.,40)##dindgen(300)
tvscl,ss,50,50

stop
end
;====================================================================
pro loadctbw,ctbl,flip=flip,_extra=_extra

n=!d.table_size
loadct,0,/si
loadct,ctbl,bottom=1,ncolors=n-2,_extra=_extra

if keyword_set(flip) then begin
  tvlct,r,g,b,/get
  r[1:n-2]=reverse(r[1:n-2])
  b[1:n-2]=reverse(b[1:n-2])
  g[1:n-2]=reverse(g[1:n-2])
  tvlct,r,g,b
endif

end
;====================================================================
function range,array,NAN=nan

 On_error,2
 amin = min( array, MAX = amax, NAN=nan)
 return, amax - amin
end
;====================================================================
function path2file,infiles,path=path

 sep=!version.os eq 'windows' ? '\' : '/'
 nf=n_elements(infiles)
 outfiles=infiles & path=infiles
 for i=0,nf-1 do begin
   while strpos(outfiles[i],sep) ne -1 do outfiles[i]=strmid(outfiles[i],strpos(outfiles[i],sep)+1)
   path[i]=strmid(infiles[i],0,strlen(infiles[i])-strlen(outfiles[i]))
 endfor

 return,outfiles
end
;====================================================================
pro colors
;Set colors for plotting. Note that the number of colors in the color map
;  may change when the first window is created. This can lead to a default
;  plotting color other than white. Either create the window before calling
;  colors, or call colors again once the window has been created.
;27-Mar-94 JAV Created.

;Characterize color map. Initialize new color map.
  nshades = 256					;number of shades
  tblsiz = !d.table_size			;size of color map
  r = intarr(tblsiz)
  g = intarr(tblsiz)
  b = intarr(tblsiz)

;Specify progression of colors.
  rtmp = [ 1.0, 1.0, 0.2, 0.0, 1.0, 1.0, 1.0, 0.2 $
         , 1.0, 0.4, 0.6, 0.6, 1.0, 0.2, 0.6, 0.75]
  gtmp = [ 1.0, 0.0, 1.0, 0.4, 1.0, 0.4, 0.6, 1.0 $
         , 0.8, 0.6, 0.0, 0.4, 0.4, 0.8, 0.6, 0.75]
  btmp = [ 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0 $
         , 0.6, 0.0, 0.6, 0.0, 0.0, 0.4, 0.4, 0.75]

;Scale to fill available shades.
  rtmp = fix((nshades-1) * rtmp)
  gtmp = fix((nshades-1) * gtmp)
  btmp = fix((nshades-1) * btmp)

;Replicate color progression and fill color map. First entry is left black.
  tmpsiz = n_elements(rtmp)			;template size
  unit = replicate(1, tblsiz/tmpsiz+1)
  r(1:tblsiz-1) = (rtmp # unit)(0:tblsiz-2)
  g(1:tblsiz-1) = (gtmp # unit)(0:tblsiz-2)
  b(1:tblsiz-1) = (btmp # unit)(0:tblsiz-2)

;Set last entry in color map to white.
  r(tblsiz-1) = nshades-1
  g(tblsiz-1) = nshades-1
  b(tblsiz-1) = nshades-1

;Load color map.
  tvlct,r,g,b

end
;====================================================================
Function	ImgExp, image, $
			xs, ys, $
			out_xs, out_ys, $
			x_ran, y_ran, $
			ASPECT=aspect, $
			INTERPOLATE=interp, $
			MASKVALUE=maskvalue, $
			PS_INTERP_SIZE=psis, $
			POSITION=p, $
			NO_EXPAND=no_expand, $
			HELP=help

SccsId = '@(#)imgexp.pro 2.2 7/16/93 Fen Tamanaha'
;+
; NAME:
;	IMGEXP
;
; PURPOSE:
;	This function expands the array <Image> to fill the current plotting
;	window.  This routine works for both X and PostScript devices.  The
;	optional scales <XS> and <YS> are likewise transformed and returned
;	in option parameters <Out_XS> and <Out_YS>.
;
; CATEGORY:
;	Image expansion.
;
; CALLING SEQUENCE:
;	Result = IMGEXP(Image, XS, YS, Out_XS, Out_YS, X_Ran, Y_Ran)
;
; INPUTS:
;	Image:	Two-dimensional array to be expanded.
;
; OPTIONAL INPUTS:
;	XS:	Vector of x-axis values.  The length must equal the number of
;		rows in <Image>
;
;	YS:	Vector of y-axis values.  The length must equal the number of
;		columns in <Image>
;
; KEYWORD PARAMETERS:
;	ASPECT=	Set this keyword to the aspect ratio (width/height) of the
;		pixels.  /ASPECT is the same as ASPECT=1 and produces square
;		pixels.
;
;	/INTERPOLATE:
;		Set this switch to enable bilinear interpolation for pixels
;		in the expanded image.  See /PS_INTERP_SIZE for information
;		on using this switch on a PostScript device.
;
;	MASKVALUE=
;		Set this keyword to the value that uninterpolated pixels around
;		the border of the image should be given.  The default is 
;		-9999.0.  Interpolation is not performed beyond the centers of
;		the original pixels.
;
;	PS_INTERP_SIZE=
;		Since PostScript devices have scalable pixels it is necessary
;		to force expansion to at most this many pixels in either
;		dimension.  The default is 256.  (It's really more complicated
;		than this.  Read the code if you need to know.)
;
;	POSITION=
;		Set this keyword to the variable that is to hold the four-
;		element vector containing the device coordinates of the
;		plotting region that will contain the expanded image.  This
;		is designed to be used by subsequent TV and PLOT commands.
;
;	/NO_EXPAND:
;		Set this switch to prevent the image from being expanded
;		to fill the plotting window.  An aspect ration of 1:1 is
;		forced for PostScript output so that it conforms to the X
;		window view.
;
; OUTPUTS:
;	Result:	This function returns an expanded version of the input <Image>
;		possibly interpolated.
;
; OPTIONAL OUTPUTS:
;	Out_XS:	Vector of x-axis values corresponding the the expanded image.
;
;	Out_YS:	Vector of y-axis values corresponding the the expanded image.
;
;	X_Ran:	Two-element vector that contains the full x-axis range
;		including the width of the pixels.  It is designed to be used
;		as input to the PLOT command.
;	
;	Y_Ran:	Two-element vector that contains the full y-axis range
;		including the height of the pixels.  It is designed to be used
;		as input to the PLOT command.
;	
; RESTRICTIONS:
;	This routine may work for other devices, but it has only been tested
;	on 'X' and 'PS'.
;
; PROCEDURE:
;	Straight forward.  :-)
;
; EXAMPLE:
;	p = 0
;	big = IMGEXP(small, lon, lat, biglon, biglat, xr, yr, Position=p)
;	TVSCL, big, p(0), p(1), /Device
;	Plot, [0,1], /NoData, /NoErase, Position=p, /Device, $
;		XRange=xr, YRange=yr
;
;	junk = IMGSCL( )	;prints out a "Usage:" line
;
; MODIFICATION HISTORY:
; 	Written by:	Fen Tamanaha, July 9, 1993.  Release 2.1
;	July 16, 1993	Fen: (2.2) Added /No_Expand keyword
;-

    On_Error, 2

;
; Go through the optional parameters.
;
    n_parms = N_Params()
    If ( Keyword_Set(help) ) Then n_parms = 0
    Case ( n_parms ) Of 
	0: Begin
	    Message, 'im = IMGEXP(image [,xs [,ys [,out_xs [,out_xs [,x_ran [,y_ran]]]]]]', /Info
	    Message, '            [,ASPECT=] [,/INTERPOLATE] [,MASKVALUE=]', /Info
	    Message, '            [,PS_INTERP_SIZE=] [,POSITION=] [,/NO_EXPAND]', /Info
	    Return, 0
	End
        1: Begin
            sz = Size(image)
            If ( sz(0) NE 2 ) Then Begin
                Message, '<image> must be an array.'
            EndIf
            xs = FIndGen(sz(1))
            ys = FIndGen(sz(2))
        End
        2: Begin
            sz = Size(image)
            If ( sz(0) NE 2 ) Then Begin
                Message, '<image> must be an array.'
            EndIf
            If ( N_Elements(xs) NE sz(1) ) Then Begin
                Message, '<xs> does not match <image> dimensions.'
            EndIf
            ys = FIndGen(sz(2))
        End
        3: Begin
            sz = Size(image)
            If ( sz(0) NE 2 ) Then Begin
                Message, '<image> must be an array.'
            EndIf
            If ( N_Elements(xs) NE sz(1) ) Then Begin
                Message, '<xs> does not match <image> dimensions.'
            EndIf
            If ( N_Elements(ys) NE sz(2) ) Then Begin
                Message, '<ys> does not match <image> dimensions.'
            EndIf
        End
	Else: Begin
            sz = Size(image)
            If ( sz(0) NE 2 ) Then Begin
                Message, '<image> must be an array.'
            EndIf
	End
    EndCase

;
; Establish image variables and determine the aspect ration.
;
    im_x_width = Float(sz(1))			;image width
    im_y_width = Float(sz(2))			;image height
    im_aspect = im_x_width / im_y_width		;image aspect (width/height)

;
; If MASKVALUE contains a value, then that value is assumed to be a flag
;	for data not to be used in scaling.  Is also the value that will
;	be used to "blank out" the border region which could not be 
;	interpolated.  If MASKVALUE does not contain a value then it will
;	be assigned to -9999.0 and used to "blank out" the border
;	region.  A warning is issued if interpolation and thus border
;	blanking will occur.
;
    If ( N_Elements(maskvalue) LE 0 ) Then Begin
	maskvalue = -9999.0
	If ( Keyword_Set(interp) ) Then Begin
	    msg = String(Format='("Warning: Uninterpolated border set to ", F7.0, ".")', maskvalue)
	    Message, msg, /Info
	EndIf
    EndIf

;
; No matter what keywords are set, the same axis ranges will be used.  To
;	account for pixel width, the ranges extend half a pixel width
;	beyond the specified centers.  Because this routine does not
;	interpolate beyond the pixel centers, interpolation will cause
;	this border region to be set to the background color.
;
    xs_delta = (xs(im_x_width-1) - xs(0)) / Float(im_x_width - 1.0)
    ys_delta = (ys(im_y_width-1) - ys(0)) / Float(im_y_width - 1.0)
    x_ran = [xs(0)-xs_delta/2.0,xs(im_x_width-1)+xs_delta/2.0]
    y_ran = [ys(0)-ys_delta/2.0,ys(im_y_width-1)+ys_delta/2.0]

;
; Use a dummy plot to determine the plot region, establish device variables,
;	and determine the aspect ratio.
;
    Plot, [0,1], /NoData, XStyle=4, YStyle=4, /NoErase

    dev_x_range = !X.Window * !D.X_VSize	;window range in device
    dev_y_range = !Y.Window * !D.Y_VSize	; coordinates
    dev_x_width = dev_x_range(1) - dev_x_range(0) + 1
    dev_y_width = dev_y_range(1) - dev_y_range(0) + 1
    dev_aspect = dev_x_width / dev_y_width	;device aspect (width/height)

;
; If ASPECT has been set and is greater than zero, then it contains the 
;	aspect ratio of each pixel.  The pixel shape is maintained by 
;	altering the device coordinate widths of the plotting region.
; The aspect ratio is forced to 1:1 so that the behavior under PostScript
;	mimic the X display.
;
    If ( N_Elements(aspect) GT 0 ) Then Begin
	pix_aspect = aspect(0)
    EndIf Else Begin
	pix_aspect = 0.0
    EndElse
    If ( pix_aspect LT 0 ) Then Begin
	Message, 'Warning: ASPECT cannot be negative --- ignoring.', /Cont
	pix_aspect = 0.0
    EndIf

    If ( Keyword_Set(no_expand) ) Then Begin
	If ( pix_aspect NE 0.0 ) Then Begin
	    Message, 'Warning: ASPECT keyword ignored by /NO_EXPAND.', /Cont
	EndIf
	pix_aspect = 1.0			;force square pixels

	If ( Keyword_Set(interp) ) Then Begin
	    Message, 'Warning: INTERPOLATE keyword ignored by /NO_EXPAND.', $
									/Cont
	EndIf
    EndIf

    If ( pix_aspect GT 0.0 ) Then Begin
	aspect_ratio = im_aspect * pix_aspect / dev_aspect
	If ( aspect_ratio GT 1.0 ) Then Begin
	    dev_y_width = dev_y_width / aspect_ratio
        EndIf Else Begin
	    dev_x_width = dev_x_width * aspect_ratio
        EndElse
    EndIf

;
; Set the plotting window position.
;
    p = [dev_x_range(0),dev_y_range(0), $
		dev_x_range(0)+dev_x_width,dev_y_range(0)+dev_y_width]

;
; If the plotting device has scalable pixels, then manual expansion is not
;	necessary unless interpolation is desired.  If the the pixels are
;	not hardware scalable, then the expansion must be performed here.
; PostScript has scalable pixels while the windows do not.  Interpolation is
;	not allowed when /No_Expand is set.
;
    scalable = (!D.Flags And 1) NE 0
    If ( scalable ) Then Begin
	If ( Keyword_Set(interp) And Not Keyword_Set(no_expand) ) Then Begin
	;
	; Interpolation for scalable pixels is a bit tricky.  The approach
	;	taken here is to shrink the plotting region down to some
	;	reasonable size.  The image is then expanded over this
	;	intermediate region and when plotted, will expand to the
	;	appropriate size.  The keyword PS_INTERP_SIZE= can be used
	;	to override the default maximum size (256).
	;
	    If ( N_Elements(psis) GT 0 ) Then Begin
		width_limit = 1.0 * psis(0)	;max size of interp region
	    EndIf Else Begin
		width_limit = 256.0		;def max size of interp region
	    EndElse
            ws = dev_x_width / width_limit	;width reduction factor
            hs = dev_y_width / width_limit	;height reduction factor
            dev_fact = Max([hs,ws])		;select largest factor
            reg_x_width = dev_x_width / dev_fact    ;limit number of device
            reg_y_width = dev_y_width / dev_fact    ; pixels in interp region

	;
	; An index grid for interpolation is constructed.  INTERPOLATE is
	;	used to interpolate the image and the scales.
	;
            x_factor = reg_x_width / im_x_width
            y_factor = reg_y_width / im_y_width
            x_offset = (x_factor - 1.0) / x_factor / 2.0
            y_offset = (y_factor - 1.0) / y_factor / 2.0
            xi = FIndGen(reg_x_width) / x_factor - x_offset	;x interp index
            yi = FIndGen(reg_y_width) / y_factor - y_offset	;y interp index

            im = Interpolate(image, xi, yi, /Grid, Missing=maskvalue)

	EndIf Else Begin
	;
	; With scalable pixels the image can be put directly on the TV and
	;	the scales don't need any reworking.  But, an index grid 
	;	is still constructed so we can computer the scales.
	;
            xi = FIndGen(im_x_width) 		;x interp index
            yi = FIndGen(im_y_width) 		;y interp index

	    im = image

	EndElse

    EndIf Else Begin		;scalable pixels
    ;
    ; Pixels that are not scalable require that we actually increase the
    ;	size of the image to match the device widths.  Whether or not we
    ;	are interpolating the pixels, we do need to interpolate the
    ;	axis scales.  The following computes an interpolation grid.
    ;
      If ( Keyword_Set(no_expand) ) Then Begin
      ;
      ; If /No_Expand is set then return original image and scales.  The
      ;		ploting region is reduced to the image width.
      ;
        xi = FIndGen(im_x_width) 		;x interp index
        yi = FIndGen(im_y_width) 		;y interp index
	im = image
	p(2) = P(0) + im_x_width
	p(3) = p(1) + im_y_width

      EndIf Else Begin				;expand image
        x_factor = dev_x_width / im_x_width
        y_factor = dev_y_width / im_y_width
        x_offset = (x_factor - 1.0) / x_factor / 2.0
        y_offset = (y_factor - 1.0) / y_factor / 2.0
        xi = FIndGen(dev_x_width) / x_factor - x_offset	;x interp index
        yi = FIndGen(dev_y_width) / y_factor - y_offset	;y interp index

	If ( Keyword_Set(interp) ) Then Begin
	;
	; An index grid for interpolation is constructed.  INTERPOLATE is
	;	used to interpolate the image and the scales.
	;
            im = Interpolate(image, xi, yi, /Grid, Missing=maskvalue)

	EndIf Else Begin
	;
	; If interpolation is not required then we use a "simple" POLY_2D
	;	warping.  This works since without interpolation POLY_2D
	;	uses truncation (not nearest neighbor) to determine the
	;	value of the interpolated pixels.  Thus, the pixel center
	;	shifting logic is not necessary.
	    im = Poly_2D(image, [[0,0],[1.0/x_factor,0]], $
				[[0,1.0/y_factor],[0,0]], $
				0, dev_x_width, dev_y_width)
	EndElse
      EndElse

    EndElse	;not scalable

;
; Compute the expanded axis scales.
;
    out_xs = xi * xs_delta + xs(0)
    out_ys = yi * ys_delta + ys(0)

    Return, im
End
;====================================================================
Function	ImgScl, array, $
			MIN=min_lvl, MAX=max_lvl, $
			TOP=top, $
			LEVELS=l, $
			LOG=log_scl, $
			HIST=hist_eq, $
			MASKVALUE=maskvalue


SccsId = '@(#)imgscl.pro 2.1 7/12/93 Fen Tamanaha'
;+
; NAME:
;	IMGSCL
;
; PURPOSE:
;	This function mimics BYTSCL() except that it maps the input range
;	into a byte range from 1 through TOP.  A byte value of 0 is reserved
;	for elements containing MASKVALUE usually assigned for bad pixels or
;	those without data.  The function can also perform logarithmic scaling
;	of the data into byte values.  Use of the LEVELS keyword will scale
;	all value within a given level to a single byte value.
;
; CATEGORY:
;	Image scaling.
;
; CALLING SEQUENCE:
;	Result = IMGSCL(Array)
;
; INPUTS:
;	Array:	Two-dimensional array to be expanded.
;
; KEYWORD PARAMETERS:
;	MIN=	The minimum value of Array to be considered.  If MIN is not
;		provided, Array is searched for its minimum value.  All
;		values less than or equal to MIN are set to 1 in the Result.
;
;	MAX=	The maximum value of Array to be considered.  If MAX is not
;		provided, Array is searched for its maximum value.  All
;		values greater than or equal to MAX are set to TOP in the
;		Result.
;
;	TOP=	The maximum value of the scaled result.  If TOP is not
;		specified, 255 is used. Note that the minimum value of the
;		scaled result is always 1 (NOT 0 as in BYTSCL).
;
;	LEVELS=	Set this keyword to a vector of data value boundaries between
;		which all elements of the Array have the same scaled byte
;		value.  e.g. LEVELS=[0,1,2,5] maps all values below 0 and
;		above 5 to 0B, map values between 0 and 1 to 1B, map values
;		between 1 and 2 to 128B, and map values between 2 and 5 to
;		255B.
;
;	/LOG:	Set this switch to cause a logarithmic mapping.  This is
;		overridden by the LEVELS keyword.
;
;	MASKVALUE=
;		Set this keyword to the value that pixels with bad data or
;		no data have been flagged with.  These will be mapped to 0B.
;
; OUTPUTS:
;	Result:	This function returns a byte array between 1 and TOP for data
;		in Array between MIN and MAX.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straight forward.  :-)
;
; EXAMPLE:
;	image = IMGSCL(array, Min=-1, Top=!D.Table_Size-1, /Log, Mask=-9999.0)
;	TV, image
;
;	image = IMGSCL(array, Levels=[0,1,2,4,8,16,32])
;	TV, image		;plot with 6 colors plus the background
;
; MODIFICATION HISTORY:
; 	Written by:	Fen Tamanaha, July 10, 1993.  Release 2.1
;-

    On_Error, 2

;
; Check parameters and keywords.
;
    If ( N_Params() NE 1 ) Then Begin
	Message, 'Usage: Image = ImgScl(array [,MIN=] [,MAX=] [,TOP=] [,LEVELS=]', /Info
	Message, '                      [,MASKVALUE=] [,/LOG])', /Info
	Return, 0B
    EndIf

    If ( (Size(array))(0) LT 1 ) Then Begin
	Message, 'Error: <array> must be an array.'
    EndIf

;
; Use MASKVALUE to determine the indices that contain valid data.
;
    If ( N_Elements(maskvalue) GT 0 )  Then Begin
	valid = Where(array NE maskvalue, valid_count)
	If ( valid_count LT 1 ) Then Begin
	    Message, 'Warning: <array> contains only masked values.', /Cont
	    Return, Byte(0.0 * array)
	EndIf
    EndIf Else Begin
	valid = LIndGen(N_Elements(array))
    EndElse

;
; If not passed, compute maximum and minimum data values for the non-masked
;	elements.
;
    If ( N_Elements(min_lvl) LE 0 ) Then Begin
	min_lvl = Min(array(valid), Max=tmp_max)
    EndIf
    If ( N_Elements(max_lvl) LE 0 ) Then Begin
	If ( N_Elements(tmp_max) EQ 0 ) Then Begin
	    max_lvl = Max(array(valid))
	EndIf Else Begin
	    max_lvl = tmp_max
	EndElse
    EndIf

    If ( N_Elements(top) LE 0 ) Then Begin
	top = 255B
    EndIf

    If ( Keyword_Set(log_scl) ) Then Begin
	scaling_type = 1
	low_clip = 0.01		;lowest value allowed with the ALog10
    EndIf Else If ( Keyword_Set(hist_eq) ) Then Begin
        scaling_type = 3        ;histogram equalization
    EndIf Else Begin
	scaling_type = 0
    EndElse

    n_lvls = N_Elements(l)
    Case ( n_lvls ) Of
	0: Begin
	    ; Ignore this keyword.
	End
	1: Begin
	    Message, 'Error: LEVELS must contain at least 3 entries.'
	End
	2: Begin
	    Message, 'Error: LEVELS must contain at least 3 entries.'
	End
	Else: Begin
	    scaling_type = 2
	End
    EndCase

;
; Perform scaling from <MIN>:<MAX> to <1>:<TOP>.
;
    Case ( scaling_type ) Of
	0: Begin
	    image = BytScl(array, Min=min_lvl, Max=max_lvl, Top=top-1B) + 1B
	End
	1: Begin
	    tmp = 1.0 + (array <max_lvl >min_lvl) - min_lvl
	    tmp = ALog10(Temporary(tmp) >low_clip)
	    image = BytScl(tmp, Top=top-1B) + 1B
	End
	2: Begin
	;
	; Produce grayscale plateaus at the level breaks.  All level boundaries
	;	MUST be specified.  This requires a minimum of 3 elements
	;	in LEVELS (bottom of low bin, transition value, and top of
	;	high bin).  All values outside of these levels is mapped to
	;	the background color table entry of 0B.
	;
	    levels = l(Sort(l))
	    image = Byte(array * 0)
	    blk_size = Float(top + 1) / Float(n_lvls - 2)

	;
	; Assign each successive block the next color index.
	;
	    For step = 0, n_lvls-2 Do Begin
		index = Where( (array GE levels(step)) And $
			(array LE levels(step+1)), count)
		If ( count GT 0 ) Then Begin
		    image(index) = Byte((step)*blk_size) >1B <top
		EndIf Else Begin
		    msg = String(Format='("Warning: No array values between levels ", I2, " and ", I2, ".")', step, step+1)
		    Message, msg, /Cont
		EndElse
		color = Byte((step+1.0)*blk_size)
	    EndFor

	;
	; Set values that are out of range to 0B.
	;
	    index = Where( (array LT levels(0)) Or $
			(array GT levels(n_lvls-1)), count)
	    If ( count GT 0 ) Then Begin
		image(index) = 0B
	    EndIf

	End
        ;
        ; Histogram normalization (Oct. 2001, N.Piskunov)
        ;
	3: Begin
;	    tmp = 1.0 + (array <max_lvl >min_lvl) - min_lvl
            tmp = (array <max_lvl >min_lvl) - min_lvl
	    tmp = Hist_Equal(tmp, bin=(max_lvl - min_lvl)/255.)
	    image = BytScl(tmp, Top=top-1B) + 1B
	End
	Else: Begin
	    Message, 'Program Bug: Scaling type in error.'
	End
    EndCase

;
; Set the pixels with a value of MASKVALUE to zero.
;
    If ( N_Elements(maskvalue) GT 0 ) Then Begin
	masked = Where(array EQ maskvalue(0), count)
	If ( count GT 0 ) Then Begin
	    image(masked) = 0B
	EndIf
    EndIf

    Return, image
End
;====================================================================
Pro Display, image, $
            xarg, yarg, $
            Title=t, XTitle=xt, YTitle=yt, $
            MIN=minval, MAX=maxval, $
            HIST=hist_eq, $
            LOG=log_scaling, $
            LEVELS=l, $
            Xrange=xrange, Yrange=yrange,  $
            ASPECT=aspect, $
            INTERPOLATE=interp, $
            MASKVALUE=maskvalue, $
            PSFINE=psfine, $
            NO_EXPAND=no_expand, $
            NOERASE=noerase, $
            xticks=xticks,yticks=yticks, $
            xstyle=xstyle, ystyle=ystyle, $
            xtickint=xtickint,ytickint=ytickint, $
            HELP=help

SccsId = '@(#)display.pro 3.3 7/16/93 Fen Tamanaha'
;+
; NAME:
;	DISPLAY
;
; PURPOSE:
;	This procedure will display an image with the TV command that fills
;	the plotting window.  It handles scale, annotations, X and PostScript
;	devices, aspect ratios, logarithmic scaling, and interpolation.  The
;	first colormap entry is reserved for the background (pixels flagged
;	with the MASKVALUE value are mapped to this color) and the last entry
;	is reserved for user defined colored annotations.  The annotation
;	plotted by this procedure are in the color !P.Color.
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:
;	DISPLAY, Image, Xarg, Yarg
;
; INPUTS:
;	Image:	Two-dimensional array to be displayed.
;
; OPTIONAL INPUTS:
;	Xarg:	Vector of x-axis values.  The length must equal the number of
;		rows in <Image>
;
;	Yarg:	Vector of y-axis values.  The length must equal the number of
;		columns in <Image>
;
; KEYWORD PARAMETERS:
;	TITLE=	Set this keyword to a string containing the title annotation
;		to be used by PLOT.
;
;	XTITLE=	Set this keyword to a string containing the x-axis annotation
;		to be used by PLOT.
;
;	YTITLE=	Set this keyword to a string containing the y-axis annotation
;		to be used by PLOT.
;
;	ASPECT=	Set this keyword to the aspect ratio (width/height) of the
;		pixels.  /ASPECT is the same as ASPECT=1 and produces square
;		pixels.
;
;	/INTERPOLATE:
;		Set this switch to enable bilinear interpolation for pixels
;		in the expanded image.  See /PS_FINE for information
;		on using this switch on a PostScript device.
;
;	MASKVALUE=
;		Set this keyword to the value that pixels with bad data or
;		no data have been flagged with.  These will be mapped to 0B.
;
;	MIN=	The minimum value of <Image> to be considered.  If MIN is not
;		provided, <Image> is searched for its minimum value.  All
;		values less than or equal to MIN are set to 1 in the Result.
;
;	MAX=	The maximum value of <Image> to be considered.  If MAX is not
;		provided, <Image> is searched for its maximum value.  All
;		values greater than or equal to MAX are set to TOP in the
;		Result.
;
;	TOP=	The maximum value of the scaled result.  If TOP is not
;		specified, 255 is used. Note that the minimum value of the
;		scaled result is always 1 (NOT 0 as in BYTSCL).
;
;	LEVELS=	Set this keyword to a vector of data value boundaries between
;		which all elements of <Image> have the same scaled byte
;		value.  e.g. LEVELS=[0,1,2,5] maps all values below 0 and
;		above 5 to 0B, map values between 0 and 1 to 1B, map values
;		between 1 and 2 to 128B, and map values between 2 and 5 to
;		255B.  This does not plot contours.
;
;	/HIST:	Set this switch to show histogram equalized image.  This is
;		overridden by the LEVELS and LOG keywords.
;
;	/LOG:	Set this switch to cause a logarithmic mapping.  This is
;		overridden by the LEVELS keyword.
;
;	/PS_FINE:
;		Set the switch to enable higher resolution images on a
;		PostScript device.  This is only useful with /INTERPOLATE and
;		will increase the size of the PostScript file.
;
;	/NOERASE:
;		Set the switch to prevent output device from being erased
;		before the image, scales, and annotations are displayed.
;
;	/NO_EXPAND:
;		Set this switch to prevent the image from being expanded
;		to fill the plotting window.  Scaling to byte type is still
;		performed.
;
; SIDE EFFECTS:
;	TV display is altered.
;
; RESTRICTIONS:
;	This routine may work for other devices, but it has only been tested
;	on 'X' and 'PS'.
;
; PROCEDURE:
;	Straight forward.  :-)
;
; EXAMPLE:
;	LoadCT, 3
;	image = SHIFT(DIST(20, 20), 10, 10)
;	scale = FINDGEN(20) - 10.0
;	DISPLAY, image, scale, scale, /INTERPOLATE, TITLE='!6Smooth Slope', $
;		/ASPECT
;	;Use CONTOUR with /OVERPLOT to overlay contours.
;	CONTOUR, image, scale, scale, LEVELS=1.0+FINDGEN(4)*2.0, /OVERPLOT
;
;	DISPLAY		;prints out a "Usage:" line
;
; MODIFICATION HISTORY:
; 	Written by:	Fen Tamanaha, July 10, 1993.  Release 3.1
;	July 13, 1993	Fen: (3.2) Fixed /No_Expand
;	July 16, 1993	Fen: (3.3) Really fixed /No_Expand
;-

    On_Error, 2

;
; Validate arguments.
;
    nparms = N_Params()
    If ( Keyword_Set(help) ) Then nparms = 0	;force a "Usage:" line
    Case ( nparms ) Of
        1: Begin
            sz = Size(image)
            If ( sz(0) NE 2 ) Then Begin
                Message, '<image> must be an array.'
            EndIf
            xarg = FIndGen(sz(1))
            yarg = FIndGen(sz(2))
        End
        2: Begin
            sz = Size(image)
            If ( sz(0) NE 2 ) Then Begin
                Message, '<image> must be an array.'
            EndIf
            If ( N_Elements(xarg) NE sz(1) ) Then Begin
                Message, '<xarg> does not match <image> dimensions.'
            EndIf
            yarg = FIndGen(sz(2))
        End
        3: Begin
            sz = Size(image)
            If ( sz(0) NE 2 ) Then Begin
                Message, '<image> must be an array.'
            EndIf
            If ( N_Elements(xarg) NE sz(1) ) Then Begin
                Message, '<xarg> does not match <image> dimensions.'
            EndIf
            If ( N_Elements(yarg) NE sz(2) ) Then Begin
                Message, '<yarg> does not match <image> dimensions.'
            EndIf
        End
        Else: Begin
            Message, 'Usage: DISPLAY, image [,xarg [,yarg]] [,TITLE=] [,XTITLE=] [,YTITLE=]', /Info
            Message, '           [,xticks=xticks] [,yticks=yticks]', /Info
	    Message, '           [,MIN=] [,MAX=] [,/LOG] [,LEVELS=]', /Info
            Message, '           [,ASPECT=] [,/INTERPOLATE] [MASKVALUE=]', /Info
	    Message, '           [,/NO_EXPAND] [,/NOERASE] [,/PSFINE]', /Info
	    Message, '           [,XSTYLE=] [,YSTYLE=]', /Info
            Return
        End
    EndCase
    
    if(keyword_set(xstyle)) then xs=xstyle else xs=1
    if(keyword_set(ystyle)) then ys=ystyle else ys=1
 
;
; The plotting device must be erased to reset the system variables so that
;	IMGEXP will get the default values.  The /NOERASE keyword should
;	be used to prevent this.  One typical situation is when DISPLAY
;	is called after a !P.MULTI change.  An ERASE at this point would
;	destroy the previous plots.
;
; Modification by N.Piskunov: monitor the change of !p.multi:
;
    pmulti=!p.multi(1)*!p.multi(2)
    If ( Not Keyword_Set(noerase) ) Then Begin
        if(!p.multi(0) eq 0 or pmulti eq 0) then Erase
    EndIf

;
; If /PSFINE is set then up the intermediate interpolated image width.
;	This only has an effect on PostScript output.
;
    If (Keyword_Set(psfine) ) Then Begin
	psis = 512.0
    EndIf

;
; Modification by N.Piskunov: add conventional Xrange and Yrange parameters
; to display:
;
    ix = indgen(sz(1))
    If (n_elements(xrange) eq 2) Then Begin
      ix = where(xarg ge xrange(0)<xrange(1) and xarg le xrange(0)>xrange(1), nix)
      If (nix eq 0) Then ix = indgen(sz(1)) Else $
      If (xrange(0) gt xrange(1)) Then ix = ix(reverse(ix))
    EndIf
    
    iy = indgen(sz(2))
    If (n_elements(yrange) eq 2) Then Begin
      iy = where(yarg ge yrange(0)<yrange(1) and yarg le yrange(0)>yrange(1), niy)
      If (niy eq 0) Then iy = indgen(sz(2)) Else $
      If (yrange(0) gt yrange(1)) Then iy = iy(reverse(iy))
    EndIf

    im = image(ix, *) & im = im(*, iy)

    im = ImgExp(im, xarg(ix), yarg(iy), xscale, yscale, xrange, yrange, $
		Aspect=aspect, Interpolate=Keyword_Set(interp), $
		MaskValue=maskvalue, Position=dev_pos, PS_Interp_Size=psis, $
		No_Expand=Keyword_Set(no_expand))
    sz = Size(im)
    im_x_width = Float(sz(1))                   ;image width
    im_y_width = Float(sz(2))                   ;image height
 
;
; Determine the device coordinates of the plotting regions.
;
    dev_x_width = dev_pos(2) - dev_pos(0) + 1
    dev_y_width = dev_pos(3) - dev_pos(1) + 1
    If ( (im_x_width GT dev_x_width) Or (im_y_width GT dev_y_width) ) Then Begin
	Message, 'Error: Scaled image is larger than plotting window.'
    EndIf

;
; Convert a non-byte type image to byte with IMGSCL.  The bottom entry
;	of the color table is reserved for the background/NODATA color
;	by IMGSCL.  The top color table entry will also be reserved
;	here for annotation color.
;
    If ( sz(sz(0)+1) GT 1 ) Then Begin
	byte_im = ImgScl(im, Min=minval, Max=maxval, Top=!D.Table_Size-2, $
			Log=log_scaling, Hist=hist_eq, Levels=l, $
                        MaskValue=maskvalue)
    EndIf Else Begin
;	Message, '<Image> is already byte type. No scaling done.', /Info
	byte_im = im
    EndElse

;
; Put the image on the TV.
;
    TV, byte_im, /Device, dev_pos(0), dev_pos(1), $
		XSize=dev_pos(2)-dev_pos(0), YSize=dev_pos(3)-dev_pos(1)

;
; Manage the title and axis labels.
;
    If ( Keyword_Set(t) ) Then Begin
        title = String(t)
    EndIf Else Begin
        title = ' '
    EndElse
 
    If ( Keyword_Set(xt) ) Then Begin
        xtitle = String(xt)
    EndIf Else Begin
        xtitle = ' '
    EndElse
 
    If ( Keyword_Set(yt) ) Then Begin
        ytitle = String(yt)
    EndIf Else Begin
        ytitle = ' '
    EndElse
 
;
; Overplot annotations.
;
; Modification by N.Piskunov: update !p.multi if needed:
;
    Plot, [0,1], /NoErase, /NoData, XStyle=xs, YStyle=ys $
               , /Device, Position=dev_pos $
               , XRange=xrange, YRange=yrange $
               , xticks=xticks,yticks=yticks $
               , Title=title, XTitle=xtitle, YTitle=ytitle $
               , ytickint=ytickint, xtickint=xtickint 
    !p.multi(0)=!p.multi(0)-1
    if(!p.multi(0) lt 0) then !p.multi(0)=(pmulti-1)>0

    Return
End

;====================================================================
Function Transform,order,alpha,beta,xx
;
; Coordinate transformation:
;
; If order==1 then
;   1. Tilt Z-axis by alpha degrees.
;   2. Rotate around Z-axis by beta degrees.
; else
;   1. Rotate around Z-axis by beta degrees.
;   2. Tilt Z-axis by alpha degrees.
;
; Coordinate system: X - horizontal in image plane pointing right
;                    Y - vertical in image plain pointing up
;                    Z - towards the observer

  TORAD=!DPI/180
  COSA=COS(alpha*TORAD) & SINA=SIN(alpha*TORAD)
  COSB=COS(beta *TORAD) & SINB=SIN(beta *TORAD)

; Tilt of Z axis
  a=[[1.d0, 0.d0, 0.d0], $
     [0.d0, COSA,-SINA], $
     [0.d0, SINA, COSA]]

; Rotation around Z axis
  b=[[COSB,-SINB, 0.d0], $
     [SINB, COSB, 0.d0], $
     [0.d0, 0.d0, 1.d0]]

  s=size(xx)
  if(s(0) lt 3) then begin
    if(order eq 1) then begin
      x=a#xx & x=b#x
    endif else begin
      x=b#xx & x=a#x
    endelse
  endif else if(s(0) eq 3) then begin
    n=s(2) & m=s(3)
    x=dblarr(3,n,m)
    if(order eq 1) then begin
      for j=0,m-1 do x(*,*,j)=a#xx(*,*,j)
      for j=0,m-1 do x(*,*,j)=b# x(*,*,j)
    endif else begin
      for j=0,m-1 do x(*,*,j)=b#xx(*,*,j)
      for j=0,m-1 do x(*,*,j)=a# x(*,*,j)
    endelse
  endif
  return,x
end

;====================================================================

Function Dexp,x

  return,exp(x)
  ;ex=x*0d0
  ;i=where(x lt -50d0,comp=j,ni)
  ;ex[j]=exp(x[j])
  ;if ni gt 0 then ex[i]=exp(x[i])

  return,ex
end

;====================================================================

Pro PltGrid,angle,long,cl,equ=equ,nlons=nlons,nlats=nlats,thick=thick

; spherical grid on the stellar surface

  thickgrid=1.0
  if keyword_set(thick) then thickgrid=thick
  n=360+1

  hcirc=dblarr(n,2) & dr=1.0
  hcirc[*,0]=sin(dindgen(n)*!dtor)*dr
  hcirc[*,1]=cos(dindgen(n)*!dtor)*dr
  oplot,hcirc[*,0],hcirc[*,1],thick=thickgrid,col=cl

  c0=dblarr(3,n)
  if keyword_set(equ) then begin
    ltt=0.
    rd=sin((90.-abs(ltt))*!dtor)
    c0[0,*]=hcirc[*,0]*rd
    c0[2,*]=hcirc[*,1]*rd
    c0[1,*]=-dr*cos((90.-ltt)*!dtor)
    c1=Transform(0,angle,0,c0)
    ii=where(c1[1,*] le 0,nii)
    ;oplot,c1[0,ii],c1[2,ii],thick=2,col=0
    oplot,c1[0,ii],c1[2,ii],thick=4,col=0
    oplot,c1[0,ii],c1[2,ii],thick=1,col=255

    cp=dblarr(3,2)
    cp[0,*]=0.
    cp[2,*]=0.
    cp[1,*]=((-1.)^(angle gt 90.))*dr*[1.,1.3]
    c1=Transform(0,angle,0,cp)
    plots,c1[0,*],-c1[2,*],thick=4,col=0
    plots,c1[0,*],-c1[2,*],thick=1,col=255
    
    return
  endif

; latitudes
  
  if not keyword_set(nlats) then nlats=5 
  dlat=180./(nlats+1)
   
  for il=0,nlats-1 do begin
    ltt=90.-dlat*(il+1)
    rd=sin((90.-abs(ltt))*!dtor)
    c0[0,*]=hcirc[*,0]*rd
    c0[2,*]=hcirc[*,1]*rd
    c0[1,*]=-dr*cos((90.-ltt)*!dtor)
    c1=Transform(0,angle,0,c0)
    ii=where(c1[1,*] le 0,nii)
    if nii gt 0 then oplot,c1[0,ii],c1[2,ii],thick=thickgrid,col=cl
  endfor
  
; longitudes
  
  hcirc[*,0]= sin(dindgen(n)*!dtor)*dr
  hcirc[*,1]=(-1+2*(angle gt 90.))*cos(dindgen(n)*!dtor)*dr
  if not keyword_set(nlons) then nlons=6 
  dlon=360./nlons/2.
   
  for il=0,nlons-1 do begin  
    ln=90.+dlon*il-long
    c0[0,*]=hcirc[*,0]
    c0[2,*]=hcirc[*,1]
    c0[1,*]=0.d0
    c1=Transform(0,90.-angle,ln,c0)
    ii=where(c1[1,*] ge 1d-6,nii)
    if nii gt 0 then oplot,c1[0,ii],c1[2,ii],thick=thickgrid,col=cl
  endfor

  return
end

;====================================================================

Pro DrawFld,x0,nlon,b0,incl,rtang0=rtang0,win=win,ptype=ptype,ftype=ftype,cscl=cscl

  if not keyword_set(win) then win=0
  if not keyword_set(ptype) then ptype=0
  if not keyword_set(ftype) then ftype=0
  if not keyword_set(cscl) then cscl=1.0
  if keyword_set(rtang0)  then rtang0=double(rtang0) else rtang0=0.d0
  bmod=sqrt(total(b0^2,1))

  colors
  nphase=ptype eq 1 ? 4 : 1
  
  for iphase=0,nphase-1 do begin
  
  if ptype eq 1 then begin
    rtang=-iphase/float(nphase)*360.-rtang0
    !p.position=[0.,0.5,0.25,1.0]+[1,0,1,0]*0.25*(iphase mod 2)-[0,1,0,1]*0.50*floor(iphase/2.)
  endif else begin
    rtang=-rtang0
    !p.position=[0,0,0.5,1]  
  endelse
  
; Initialize plot  
  plot,[-1.1,1.1],[-1.1,1.1],/nodata,xs=-1,ys=-1,noerase=(iphase gt 0)
  pp=findgen(33)*(!PI*2/32.)
  usersym,cos(pp),sin(pp),/fill

; Spherical plot
  if ftype then begin
    smap=bmod                            ; field modulus
    smap=total(x0*b0,1)                  ; radial field

; Resample maps on latitude-longitude grid

    nln=max(nlon)
    nlt=(size(nlon))(1)
    ll=lonarr(nlt+1)
    ll(0)=0
    for i=0,nlt-1 do ll(i+1)=ll(i)+nlon(i)

    mp1=fltarr(nln,nlt)
    x=dindgen(nln)+0.5d0
    for i=0l,nlt-1 do begin
      lll=((dindgen(nlon[i]+2)-0.5+0.5*(i mod 2))*nln)/nlon[i]
      y=[smap[ll[i+1]-1],smap[ll[i]:ll[i+1]-1],smap[ll[i]]]
      ;mp1(*,i)=spl_interp(lll,y,spl_init(lll,y),x)
      mp1(*,i)=interpol(y,lll,x)
    endfor

    scl=2
    mp2=fltarr(nln+2,nlt)
    mp2(1:nln,*)=mp1
    mp2(0,*)=mp1(nln-1,*)
    mp2(nln+1,*)=mp1(0,*)
    mp2=rebin(mp2,(nln+2)*scl,nlt*scl)
    mp1=mp2(scl-1:scl*(nln+2)-1-scl-1,*)
    nlt=nlt*scl & nln=nln*scl

    !p.background=0
    loadctbw,72,/si,/flip
    ;loadctrb,/si,/bw
    
    light=bytscl(transpose(mp1),top=byte(240))+byte(10)
    theta=(!DPI*(dindgen(nlt+1)/nlt-0.5D0))#replicate(1.,nln+1)
    phi  =replicate(1,nlt+1)#(2*!DPI*(dindgen(nln+1)/nln))
    xx=dblarr(3,nlt+1,nln+1)
    rstar=1.0d0
    rstar1=0.95d0
    xx(0,*,*)= rstar1*cos(theta)*sin(phi)
    xx(1,*,*)=-rstar1*cos(theta)*cos(phi)
    xx(2,*,*)= rstar1*sin(theta)
    rscale=1.1d0
    xx=xx/rscale

    wbox=ptype ? floor(!d.y_size/2.) : !d.y_size
    tv,star_shape(nlt+1,nln+1,incl,rtang,xx,wbox,wbox,light),ptype*(iphase mod 2)*wbox,ptype*(1-floor(iphase/2.))*wbox

; Surface grid
    colors      
    pltgrid,incl,rtang,16;,nlats=8,nlons=18

  endif

; Vector plot
  bnorm=0.15/max(bmod)
  xx0=Transform(0,incl,rtang,x0)
  bb0=Transform(0,incl,rtang,b0)*bnorm
  ip=where(xx0[2,*] ge 0.0, np, comp=im, ncomp=nm)
  ;oplot,xx0[0,im],xx0[1,im],psym=3,color=4
  ;if not ftype then oplot,xx0[0,ip],xx0[1,ip],psym=8,color=2,syms=0.5
  if not ftype then oplot,xx0[0,ip],xx0[1,ip],psym=2,color=2,syms=0.5
  inward=where(total((xx0[*,ip]+bb0[*,ip])^2,1) lt total(xx0[*,ip]^2,1), n_inward)
  ;col=replicate(!d.name eq 'X',np)
  col=replicate(1,np)
  coli=3
  if n_inward gt 0 then col[inward]=coli
  for i=0,np-1 do begin
    bx=bb0[0,ip[i]]*(-1)^(col[i] eq coli)
    by=bb0[1,ip[i]]*(-1)^(col[i] eq coli)
    oplot,xx0[0,ip[i]]+[0,bx],xx0[1,ip[i]]+[0,by],col=col[i]
  endfor

  xyouts,0.9,0.9,string(-rtang/360.,form='(F5.3)'),col=5,/data,chars=(1.5-0.5*(ptype gt 0))*cscl

  endfor

  !p.position=0
  return
end

;====================================================================

Function CompFldSB,xyz,Bd,beta,gamma,Bq,beta1,gamma1,beta2,gamma2

; Magnetic parameterization used by S.Bagnulo:
; non-axisymmetric non-aligned dipole+quadrupole

  ntot=(size(xyz))[2]

; unit vector of dipole direction

  sinb=sin( beta*!dpi/180.) & cosb=cos( beta*!dpi/180.)
  sing=sin(gamma*!dpi/180.) & cosg=cos(gamma*!dpi/180.)
  u=[sinb*sing,-sinb*cosg,cosb]

; 2 unit vectors of quadrupole direction(s)

  sinb1=sin( beta1*!dpi/180.) & cosb1=cos( beta1*!dpi/180.)
  sing1=sin(gamma1*!dpi/180.) & cosg1=cos(gamma1*!dpi/180.)
  u1=[sinb1*sing1,-sinb1*cosg1,cosb1]
  sinb2=sin( beta2*!dpi/180.) & cosb2=cos( beta2*!dpi/180.)
  sing2=sin(gamma2*!dpi/180.) & cosg2=cos(gamma2*!dpi/180.)
  u2=[sinb2*sing2,-sinb2*cosg2,cosb2]

; generate the field

  bb0=dblarr(3,ntot)
  for i=0l,ntot-1 do begin
    r=reform(xyz[*,i])
    r0=sqrt(total(r^2))
    fd=-0.5*Bd/r0^3*(u-3.*total(u*r)*r/r0^2)
    fq=-0.5*Bq/r0^4*(total(u2*r)*u1/r0+total(u1*r)*u2/r0+ $
       (total(u1*u2)/r0-5.*total(u1*r)*total(u2*r))*r/r0^3)
    bb0[*,i]=fd+fq
  endfor

  return,bb0
end

;====================================================================

Function CompFldJL,xyz,beta,phi,Bd,Bq,Bo,decenter=decenter

; Magnetic parameterization used by J.Landstreet:
; aligned axisymmetric superposition of dipole, quadrupole and octupole

; Transform stellar coordinates to magnetic coordinates
; Z-axis is used as field symmetry line.

  xyz1=Transform(0,beta,phi,xyz)
  bb1=xyz*0d0
  if not keyword_set(decenter) then decenter=0d0
  if(abs(Bd) gt 0.001) then begin
    D2=(1.0+decenter*decenter-2.0*decenter*xyz1[2,*])
    D5=sqrt(D2)^2.5
    bb1[0,*]=bb1[0,*]+Bd*3.0*xyz1[0,*]*(xyz1[2,*]-decenter)/(2.0*D5)
    bb1[1,*]=bb1[1,*]+Bd*3.0*xyz1[1,*]*(xyz1[2,*]-decenter)/(2.0*D5)
    bb1[2,*]=bb1[2,*]+Bd*(3.0*((xyz1[2,*]-decenter)^2)-D2)/(2.0*D5)
  endif
  if(abs(Bq) gt 0.001) then begin
    bb1[0,*]=bb1[0,*]+Bq*xyz1[0,*]*(5.0*(xyz1[2,*]^2)-1.0)/2.0
    bb1[1,*]=bb1[1,*]+Bq*xyz1[1,*]*(5.0*(xyz1[2,*]^2)-1.0)/2.0
    bb1[2,*]=bb1[2,*]+Bq*xyz1[2,*]*(5.0*(xyz1[2,*]^2)-3.0)/2.0
  endif
  if(abs(Bo) gt 0.001) then begin
    bb1[0,*]=bb1[0,*]+Bo*5.0*(7.0*xyz1[2,*]^3-3.0 *xyz1[2,*])*xyz1[0,*]/8.0
    bb1[1,*]=bb1[1,*]+Bo*5.0*(7.0*xyz1[2,*]^3-3.0 *xyz1[2,*])*xyz1[1,*]/8.0
    bb1[2,*]=bb1[2,*]+Bo*   (35.0*xyz1[2,*]^4-30.0*xyz1[2,*]^2+3.0)/8.0
  endif

  ;bb1[0,*]=xyz1[0,*]*Bd
  ;bb1[1,*]=xyz1[1,*]*Bd
  ;bb1[2,*]=xyz1[2,*]*Bd
  ;print,'!'

; Transform magnetic field back to stellar coordinates

  bb0=Transform(1,-beta,-phi,bb1)
  return,bb0
end

;====================================================================

Pro CompFld,grid,fld

; Compute magnetic field geometry for a given parameterization of the field
; Resulting magnetic field is given in rectangular coordinate system
  case fld.btype of
   -1: begin
         if fld.beta eq 0 and fld.phi eq 0 then b=fld.b0 else begin
           b_new  =Transform(0,fld.beta,0,fld.b0)
           xyz_new=Transform(0,fld.beta,0,grid.xyz)
           
           lat_new=!dpi/2d0-acos(xyz_new[2,*])
           lon_new=atan(xyz_new[0,*],-xyz_new[1,*])
           ii=where(lon_new lt 0,nii)
           if nii gt 0 then lon_new[ii]=2d0*!dpi-abs(lon_new[ii])
           lon_new=lon_new+fld.phi*!dtor
           
           qhull,lon_new/!dtor,lat_new/!dtor,tr,sphere=sp
           
           b=b_new*0d0
           for k=0,2 do begin
             ;b[k,*]=griddata(reform(xyz_new[0,*]),reform(xyz_new[1,*]),reform(xyz_new[2,*]),reform(b_new[k,*]),/sphere,xout=grid.lon,yout=grid.lat)
             b[k,*]=griddata(lon_new,lat_new,reform(b_new[k,*]),/sphere,xout=grid.lon,yout=grid.lat,/kriging,tr=tr,min_points=10)
           endfor
         endelse
       end         
    0: b=CompFldJL(grid.xyz,fld.beta,fld.phi,fld.Bd,0,0)
    1: b=CompFldJL(grid.xyz,fld.beta,fld.phi,fld.Bd,0,0,dec=fld.dec)
    2: b=CompFldJL(grid.xyz,fld.beta,fld.phi,fld.Bd,fld.Bq,fld.Bo)
    3: b=CompFldSB(grid.xyz,fld.Bd,fld.beta,fld.phi,fld.Bq,fld.beta1,fld.phi1,fld.beta1,fld.phi1)
  else: begin
          print,'This type of magnetic geometry is not implemented. Aborting'
          stop
        end
  endcase

; Revise magnetic field structure
  b0=fld.btype lt 0 ? fld.b0 : b
  fld={b:b,b0:b0,beta:fld.beta,phi:fld.phi,beta1:fld.beta1,phi1:fld.phi1,$
       Bd:fld.Bd,Bq:fld.Bq,Bo:fld.Bo,dec:fld.dec,btype:fld.btype}

end

;====================================================================

Function Fld2Sph, fld, grid

  ntot=n_elements(grid.theta)
  latitude=!dpi/2d0-reform(grid.theta)
  longitude=reform(grid.phi)

  fld_sph=dblarr(3,ntot)
  fld_sph[0,*]=total(grid.xyz*fld.b,1)  ; Radial field
  for i=0l,ntot-1 do begin
    b_local=Transform(0,-latitude[i]/!dtor,longitude[i]/!dtor,fld.b[*,i])
    fld_sph[1,i]=b_local[2]             ; Meridional field
    fld_sph[2,i]=b_local[0]             ; Longitudinal field
  endfor

  return,fld_sph
end

;====================================================================

Pro GridInit, ntot, grid

; generate stellar surface grid

  nlat=round(0.5D0*(1.D0+sqrt(1.D0+!DPI*ntot)))-1
  nlon=intarr(nlat)
  xlat=!DPI*(dindgen(nlat)+0.5D0)/nlat-!DPI/2.D0
  xcirc=2.D0*cos(xlat[1:*])
  nlon[1:*]=round(xcirc*nlat)+1
  nlon[0]=ntot-total(nlon[1:*])
  if(abs(nlon[0]-nlon[nlat-1]) gt nlat) then $
    nlon[1:*]=nlon[1:*]+(nlon[0]-nlon[nlat-1])/nlat
  nlon[0]=ntot-total(nlon[1:*])
  if(nlon[0] lt nlon[nlat-1]) then $
    nlon[1:*]=nlon[1:*]-1
  nlon[0]=ntot-total(nlon[1:*])

; generate Descartes coordinates for the surface grid in 
; stellar coordinates, areas of surface elements and
; regularization indices: (lower,upper,right,left)

  x0=dblarr(3,ntot) & j=0l
  latitude=dblarr(ntot) & longitude=dblarr(ntot)
  sa=dblarr(ntot) & ireg=intarr(4,ntot)
  slt=[0.,(xlat[1:nlat-1]+xlat[0:nlat-2])/2.+!dpi/2.,!dpi]
  for i=0,nlat-1 do begin
    coslat=cos(xlat[i]) & sinlat=sin(xlat[i])
    ;xlon=2*!DPI*(dindgen(nlon[i])+0.5)/nlon[i]
    xlon=2*!DPI*(dindgen(nlon[i])+0.5*(i mod 2))/nlon[i]        ; this introduces discrepancy with our standard grid definition
    sinlon=sin(xlon) & coslon=cos(xlon)
    x0[0,j:j+nlon[i]-1]= coslat*sinlon
    x0[1,j:j+nlon[i]-1]=-coslat*coslon
    x0[2,j:j+nlon[i]-1]= sinlat
    latitude [j:j+nlon[i]-1]=xlat[i]
    longitude[j:j+nlon[i]-1]=xlon
    sa[j:j+nlon[i]-1]=2.*!dpi* $
      (cos(slt[i])-cos(slt[i+1]))/nlon[i]
    ireg[2,j:j+nlon[i]-1]=shift(j+indgen(nlon[i]),-1)
    ireg[3,j:j+nlon[i]-1]=shift(j+indgen(nlon[i]), 1)
    if(i gt 0) then il_lo=j-nlon[i-1]+indgen(nlon[i-1]) $
               else il_lo=j+nlon[i  ]+indgen(nlon[i+1])
    if(i lt nlat-1) then il_up=j+nlon[i]+indgen(nlon[i+1]) $
                    else il_up=il_lo
    for k=j,j+nlon[i]-1 do begin
      dlat_lo=longitude[k]-longitude[il_lo]
      ll=where(abs(dlat_lo) eq min(abs(dlat_lo)))
      ireg[0,k]=il_lo[ll[0]]
      dlat_up=longitude[k]-longitude[il_up]
      ll=where(abs(dlat_up) eq min(abs(dlat_up)))
      ireg[1,k]=il_up[ll[0]]
    endfor  
    j=j+nlon[i]
  endfor

  theta=acos(x0[2,*])
  phi  =atan(x0[0,*],-x0[1,*])
  ii=where(phi lt 0,nii)
  if nii gt 0 then phi[ii]=2d0*!dpi-abs(phi[ii])

  grid={ntot:ntot,nlat:nlat,nlon:nlon,xyz:x0,lat:latitude,lon:longitude,area:sa,ireg:ireg,phi:phi,theta:theta}
end

;====================================================================

Pro LocPrf,iphase,vl2d,star,mu,fld,locI,locV

; Constants
  Vc=299792.458d0
  Cz=4.66864377d-13
  Nv=(size(vl2d))[1]
  Ns=(size(vl2d))[2]

; FWHM to Gaussian sigma
  sigm=star.fwhm/sqrt(8d0*alog(2d0))
  isig=(-0.5d0/sigm^2)

; Gaussian under weak-field
  if star.ltype eq 0 then begin

    bconst=-Cz*star.lande0*star.lambda0*Vc

    ex=dexp(isig*vl2d^2)
    locI=1d0-star.d[iphase]*ex
    locV=-star.d[iphase]*isig*2d0*vl2d*ex

    Blos=replicate(1d0,Nv)#reform(fld[2,*])
    locV=bconst*Blos*locV

; ME with Gaussian absorption profile
  endif else if star.ltype eq 1 then begin 

; pi-sigma component separation in velocity units
    Bmod=sqrt(total(fld^2,1))
    Vsplit=Cz*(replicate(1d0,Nv)#Bmod)*star.lande0*star.lambda0*Vc
    ex0=dexp(isig*(vl2d       )^2)
    ex1=dexp(isig*(vl2d+Vsplit)^2)
    ex2=dexp(isig*(vl2d-Vsplit)^2)

; line strength corresponding to a given local line depth in the absence of the field at mu=1
    Kl=1d0/(1d0-star.d[iphase]*(1d0+star.betaME)/star.betaME)-1d0
    
; Gaussian absorption and anomalous dispersion profiles of pi and sigma components
    tp=Kl*ex0
    tb=Kl*ex1
    tr=Kl*ex2
    rp=Kl*isig*2d0* vl2d        *ex0
    rb=Kl*isig*2d0*(vl2d+Vsplit)*ex1
    rr=Kl*isig*2d0*(vl2d-Vsplit)*ex2

; angles
    sint=dblarr(Ns)
    cost=1d0+sint
    sinc=sint
    cosc=1d0+sint    
    Btan=sqrt(fld[0,*]^2+fld[1,*]^2)    
    ii=where(Bmod gt 0d0,ni)
    if ni gt 0 then begin
      sint[ii]=Btan[ii]/Bmod[ii]
      cost[ii]=reform(fld[2,ii])/Bmod[ii]
    endif
    ii=where(Btan gt 0d0,ni)
    if ni gt 0 then begin
      sinc[ii]=reform(fld[1,ii])/Btan[ii]
      cosc[ii]=reform(fld[0,ii])/Btan[ii]
    endif
    sin2c=2d0*sinc*cosc
    cos2c=cosc^2-sinc^2

    cost=replicate(1d0,Nv)#cost
    cost2=cost^2
    sint2=replicate(1d0,Nv)#(sint^2)
    sin2c=replicate(1d0,Nv)#sin2c
    cos2c=replicate(1d0,Nv)#cos2c
    
; absorption and anomalous dispersion coefficients    
    kI=0.5d0*(tp*sint2 + 0.5d0*(tb+tr)*(1d0+cost2))
    kQ=0.5d0*(tp - 0.5d0*(tb+tr))*cos2c*sint2
    kU=0.5d0*(tp - 0.5d0*(tb+tr))*sin2c*sint2
    kV=0.5d0*(tr-tb)*cost
    fQ=0.5d0*(rp - 0.5d0*(rb+rr))*cos2c*sint2
    fU=0.5d0*(rp - 0.5d0*(rb+rr))*sin2c*sint2
    fV=0.5d0*(rr-rb)*cost

; locally normalised Stokes profiles according to Unno-Rachkovsky solution
    betmu=replicate(1d0,Nv)#(star.betaME*mu)
    betmu=betmu/(1d0+betmu)
    kI1=1d0+kI
    kI2=kI1*kI1
    delta=kI2*kI2 + kI2 * (fQ^2 + fU^2 + fV^2 - kQ^2 - kU^2 - kV^2) - (kQ*fQ + kU*fU + kV*fV)^2
    bdelta=betmu/delta

    locI= 1d0 - betmu * (1d0 - kI1 / delta * (kI2+fQ^2+fU^2+fV^2))
    ;locQ=-bdelta * (kI2*kQ - kI1*(kU*fV-kV*fU) + fQ*(kQ*fQ+kU*fU+kV*fV)) 
    ;locU=-bdelta * (kI2*kU - kI1*(kV*fQ-kQ*fV) + fU*(kQ*fQ+kU*fU+kV*fV))
    locV=-bdelta * (kI2*kV + fV*(kQ*fQ + kU*fU + kV*fV))

  endif
  
end

;====================================================================

Pro CompStokes, grid, fld, star, syn, time=time, phase=phase, vv=vv

; start timer
  t1=systime(1)

; velocity array
  if keyword_set(vv) then nv=n_elements(vv) else begin
    nv=ceil(2d0*star.vrange/star.vstep)
    vv=-star.vrange+dindgen(nv)*star.vstep+mean(star.vr)
  endelse

; phase array
  if not keyword_set(phase) then phase=dindgen(star.nphases)/star.nphases
  
; fixed trigonometric quantities
  cosi  =cos(star.incl*!dtor) & sini  =sin(star.incl*!dtor)
  coslat=cos(grid.lat)        & sinlat=sin(grid.lat)

; initialize line profile and integrated field arrays
  prfI=dblarr(star.nphases,nv)
  prfV=prfI
  Bint=dblarr(4,star.nphases)
  
; phase loop
  for i=0,star.nphases-1 do begin
    vl=vv-star.vr[i]
    
    ;print,star.phase[i],form='("Phases ",2F6.3)'
    coslon=cos(grid.lon+2d0*!dpi*phase[i])                                ; phase dependent longitude
    sinlon=sin(grid.lon+2d0*!dpi*phase[i])

    mu=sinlat*cosi+coslat*sini*coslon                                     ; mu angle
    ivis=where(mu gt 0.,nvis)	    	     	      	                  ; visible surface elements 

    dx= sinlon[ivis]*coslat[ivis]                                         ; distance from the mid-plane
    dv=-dx*star.vsini                                                     ; Doppler shift due to rotation

    vl2d=vl#replicate(1d0,nvis)+replicate(1d0,nv)#dv 	                  ; 2D array of velocity along line profile
    fld1=Transform(0,star.incl,-phase[i]*360d0,fld)                       ; transform to inclination and phase

    wgt=grid.area[ivis]*mu[ivis]*(1d0-star.limbd+star.limbd*mu[ivis])     ; integration weight: linear limb darkening
    wgtn=wgt/total(wgt)                                                   ; normalized integration weight

    if star.ltype eq 0 then begin                                         ; Gaussian WF
      LocPrf,i,vl2d,star,mu[ivis],fld1[*,ivis],locI,locV
      wgtn1=wgtn
    endif else if star.ltype eq 1 then begin                              ; Gaussian ME
      LocPrf,i,vl2d,star,mu[ivis],fld1[*,ivis],locI,locV
      ;wgt1=grid.area[ivis]*mu[ivis]*(1d0+star.betaME*mu[ivis])            ; integration weight for ME limb-darkening      
      ;wgtn1=wgt1/total(wgt1)                                              ; normalised ME limb-darkening integration weight
      wgtn1=wgtn                                                          ; adopt linear limb darkening
    endif

    prfI[i,*]=total(locI*(replicate(1d0,nv)#wgtn1),2)                     ; integration of Stokes I
    prfV[i,*]=total(locV*(replicate(1d0,nv)#wgtn1),2)                     ; integration of Stokes V

    Bint[0,i]=total(wgtn*fld1[2,ivis])                                    ; longitudinal field
    Bint[1,i]=total(wgtn*sqrt(total(fld1[*,ivis]^2,1)))                   ; field modulus
    Bint[2,i]=sqrt(total(wgtn*(total(fld1[*,ivis]^2,1)+fld1[2,ivis]^2)))  ; quadratic field
    Bint[3,i]=total(wgtn*fld1[2,ivis]*dx)                                 ; crossover
  endfor

; report timer
  t2=systime(1)
  if keyword_set(time) then print,'Surface integration: '+string((t2-t1)*[1.,1./star.nphases], $
    form='(F6.2,", ",F5.2," sec.")')

; output structure
  syn={v:vv,phase:phase,prfI:prfI,prfV:prfV,Bint:Bint}

end

;====================================================================

Pro Lprf,compare,syn

  cf=0
  if keyword_set(compare) then begin
    if strlen(compare) gt 1 then begin
      restore,compare
      cf=1
    endif
  endif
  compare=cf

end

;====================================================================

Pro DrawPrf,syn,obs,di=di,dv=dv,cscl=cscl,compare=compare,dynamic=dynamic,bint=bint

if not keyword_set(cscl) then cscl=1.0
!x.margin=[10,3]
!y.margin=[4,2]
!p.charsize=1.7*cscl
colors
nphases=n_elements(syn.phase)

; load profile to compare if any
Lprf,compare,syn0

; plot magnetic observables
if keyword_set(bint) then begin
  !p.multi=[4,4,2,0,1]
  sclf=1d-3
  title=['Longitudinal field','Field modulus','Quadratic field','Crossover']
  ytitle=['<B!dZ!n> (kG)','<B!u2!n+B!dZ!u2!n>!u1/2!n (kG)','<B> (kG)','<x B!dZ!n> (kG)']
  ii=[0,2,1,3]
  pp=findgen(33)*(!PI*2/32.)
  usersym,cos(pp),sin(pp),/fill

  for i=0,3 do begin
    k=ii[i]
    yr=minmax(syn.bint[k,*])*sclf
    if compare then yr=[yr[0]<min(syn0.bint[k,*]*sclf),yr[1]>max(syn0.bint[k,*]*sclf)]
    if keyword_set(obs) then if max(strpos(tag_names(obs),'BINT')) eq 0 then if range(obs.bint[k,*]) gt 0 then $
      yr=[yr[0]<min(obs.bint[k,*]*sclf),yr[1]>max(obs.bint[k,*]*sclf)]
    yr=yr+[-1,1]*(max(yr)-min(yr))*0.25
    plot,[0,1],yr,xs=1,ys=1,/nodata,xtitle='Phase',ytitle=ytitle[k],title=title[k],yminor=5
    if keyword_set(obs) then if max(strpos(tag_names(obs),'BINT')) eq 0 then begin
      if range(obs.bint[k,*]) gt 0 then oplot,[obs.phase,1.+obs.phase],[reform(obs.bint[k,*]),reform(obs.bint[k,*])]*sclf,syms=1.2*cscl,psym=6,col=2
    endif
    oplot,[syn.phase,1.+syn.phase],[reform(syn.bint[k,*]),reform(syn.bint[k,*])]*sclf,syms=1.0*cscl,psym=-8
    if compare then oplot,[syn0.phase,1.+syn0.phase],[reform(syn0.bint[k,*]),reform(syn0.bint[k,*])]*sclf,col=2,line=2
  endfor
  
; plot line profiles
endif else begin
  !p.multi=[2,4,1]

  if keyword_set(dynamic) then begin
    loadct,5,/si

; Stokes I dynamic plot
    i2d=transpose(syn.prfI-replicate(1d0,nphases)#avg(syn.prfI,0))
    if max(i2d)-min(i2d) lt 1e-3 then begin
      maxi= 1
      mini=-1
    endif else begin
      maxi=max(i2d)
      mini=min(i2d)
    endelse
    display,i2d,syn.v,syn.phase,xtitle='V (km s!u-1!n)',ytitle='Phase',$
      xs=1,ys=1,yr=[1,0],title='I/I!dC!n - <I/I!dC!n>',ytickint=0.1,max=maxi,min=mini,/interp

; Stokes V dynamic plot
    v2d=transpose(syn.prfV)
    display,v2d,syn.v,syn.phase,xtitle='V (km s!u-1!n)',ytitle='Phase',$
      xs=1,ys=1,yr=[1,0],title='V/I!dC!n',ytickint=0.1,/interp

    colors
  endif else begin

; stepping in Stokes I and V
    if not keyword_set(di) then di=0.5
    ystepI=di*range(syn.prfI)
    if keyword_set(obs) then if max(strpos(tag_names(obs),'PRFI')) eq 0 then ystepI=ystepI>(di*range(obs.prfI))
    if not keyword_set(dv) then dv=1.0
    ystepV=dv*range(syn.prfV)
    if keyword_set(obs) then if max(strpos(tag_names(obs),'PRFV')) eq 0 then ystepV=ystepV>(dv*range(obs.prfV))

; common range
    yrI=[min(syn.prfI),max(syn.prfI)>(max(syn.prfV)*ystepI/ystepV+1)]
    if keyword_set(obs) then begin
      if max(strpos(tag_names(obs),'PRFI')) eq 0 then begin
        yrI[0]=yrI[0]<min(obs.prfI)
        yrI[1]=yrI[1]>max(obs.prfI)
      endif
      if max(strpos(tag_names(obs),'PRFV')) eq 0 then begin
        yrI[0]=yrI[0]<(min(obs.prfV)*ystepI/ystepV+1)
        yrI[1]=yrI[1]>(max(obs.prfV)*ystepI/ystepV+1)
      endif      
    endif
    yrI[1]=yrI[1]+ystepI*(nphases-1)
    yrI=yrI+range(yrI)*[-0.05,0.05]

; Stokes I plot
    plot,minmax(syn.v),yrI,/nodata,xs=1,ys=1,xtitle='V (km s!u-1!n)',ytitle='I/I!dC!n',title='Stokes I',xminor=5
    for i=0,nphases-1 do begin
      y0=ystepI*(nphases-1-i)
      if keyword_set(obs) then if max(strpos(tag_names(obs),'PRFI')) eq 0 then oplot,obs.v,obs.prfI[i,*]+y0,psym=10,col=8
      oplot,syn.v,syn.prfI[i,*]+y0
      if compare then oplot,syn0.v,syn0.prfI[i,*]+y0,col=2,line=2
      xyouts,max(syn.v)-0.13*range(syn.v),1.0+y0+0.1*ystepI,string(syn.phase[i],form='(F5.3)'),col=5,chars=0.9*cscl
    endfor

; Stokes V plot
    yrV=[1.0-(1.0-yrI[0])*ystepV/ystepI,1.0+(yrI[1]-1.0)*ystepV/ystepI]-1.0
    plot,minmax(syn.v),yrV,/nodata,xs=1,ys=1,xtitle='V (km s!u-1!n)',ytitle='V/I!dC!n',title='Stokes V',xminor=5
    for i=0,nphases-1 do begin
      y0=ystepV*(nphases-1-i)
      if keyword_set(obs) then if max(strpos(tag_names(obs),'PRFV')) eq 0 then oplot,obs.v,obs.prfV[i,*]+y0,psym=10,col=8
      oplot,syn.v,syn.prfV[i,*]+y0
      if compare then oplot,syn0.v,syn0.prfV[i,*]+y0,col=2,line=2
      xyouts,max(syn.v)-0.13*range(syn.v),y0+0.1*ystepV,string(syn.phase[i],form='(F5.3)'),col=5,chars=0.9*cscl
    endfor

  endelse

endelse

end

;====================================================================

Pro GStokesDraw

common data,grid,fld,star,syn,obs,plt,fit

; Draw magnetic field geometry
!p.multi=[0,2,1]
DrawFld,grid.xyz,grid.nlon,fld.b,star.incl,cscl=plt.cscl,ptype=plt.fldt,ftype=plt.fldb,rtang=plt.rtang

; Plot resulting profiles
DrawPrf,syn,obs,cscl=plt.cscl,di=plt.di,dv=plt.dv,compare=plt.compare,dynamic=plt.pdyn,bint=plt.pbint

end

;====================================================================

Pro FldActive,btype,top

case btype of
  0: begin
    name1=['FBD','FBET','FPHI']
    name0=['FDEC','FBQ','FBO','FBET1','FPHI1']
  end
  1: begin
    name1=['FBD','FBET','FPHI','FDEC']
    name0=['FBQ','FBO','FBET1','FPHI1']
  end
  2: begin
    name1=['FBD','FBET','FPHI','FBQ','FBO']
    name0=['FDEC','FBET1','FPHI1']
  end  
  3: begin
    name1=['FBD','FBET','FPHI','FBQ','FBET1','FPHI1']
    name0=['FBO','FDEC']
  end
 -1: begin
    name1=['FBET','FPHI']
    name0=['FBD','FBQ','FBO','FBET1','FPHI1','FDEC']
  end
endcase

for k=0,n_elements(name1)-1 do begin
  Widget_Control,Widget_Info(top,find_by_uname=name1[k]),sensitive=1
  Widget_Control,Widget_Info(top,find_by_uname='FL'+strmid(name1[k],1)),sensitive=1
endfor
for k=0,n_elements(name0)-1 do begin
  Widget_Control,Widget_Info(top,find_by_uname=name0[k]),sensitive=0
  Widget_Control,Widget_Info(top,find_by_uname='FL'+strmid(name0[k],1)),sensitive=0
endfor    

end

;====================================================================

Pro GetFpar,event

common data,grid,fld,star,syn,obs,plt,fit

Widget_Control,Widget_Info(event.top,find_by_uname='FBD'),get_value=xval   & fld.bd=double(xval)
Widget_Control,Widget_Info(event.top,find_by_uname='FBQ'),get_value=xval   & fld.bq=double(xval)
Widget_Control,Widget_Info(event.top,find_by_uname='FBO'),get_value=xval   & fld.bo=double(xval)
Widget_Control,Widget_Info(event.top,find_by_uname='FBET'),get_value=xval  & fld.beta=double(xval)
Widget_Control,Widget_Info(event.top,find_by_uname='FPHI'),get_value=xval  & fld.phi=double(xval)
Widget_Control,Widget_Info(event.top,find_by_uname='FBET1'),get_value=xval & fld.beta1=double(xval)
Widget_Control,Widget_Info(event.top,find_by_uname='FPHI1'),get_value=xval & fld.phi1=double(xval)
Widget_Control,Widget_Info(event.top,find_by_uname='FDEC'),get_value=xval  & fld.dec=double(xval)

end

;====================================================================

Function FitPrf,par,XVAL=xval,YVAL=yval,ERRVAL=errval

common data,grid,fld,star,syn,obs,plt,fit

star.vsini=par[ 0]
star.vr[*]=par[ 1]
star.d[*] =par[ 2]
star.incl =par[ 3]
fld.Bd    =par[ 4]
fld.Bq    =par[ 5]
fld.Bo    =par[ 6]
fld.dec   =par[ 7]
fld.beta  =par[ 8]
fld.phi   =par[ 9]
fld.beta1 =par[10]
fld.phi1  =par[11]

if fit.flag[4] then CompFld,grid,fld

CompStokes,grid,fld.b,star,syn,phase=obs.phase,vv=obs.v

if fit.type eq 0 then model=reform(syn.prfI,n_elements(syn.prfI)) else $
if fit.type eq 1 then model=reform(syn.prfV,n_elements(syn.prfV))

if keyword_set(YVAL) and keyword_set(ERRVAL) then return,(YVAL-model)/ERRVAL else return,model

end

;====================================================================

Pro Err1D,name,n,dn,chi_cut,j

common fitresults,par,epar,dof,xx,yy,dd

print,name+':'
for k=-n,n,dn do print,k,form='(F6.1," ",$)'
print
chi0=total((fitprf(par,XVAL=xx,YVAL=yy,ERRVAL=dd))^2)
for k=-n,n,dn do begin
  par1=par
  par1[j]=par[j]+k*epar[j]
  dchi=total((fitprf(par1,XVAL=xx,YVAL=yy,ERRVAL=dd))^2)-chi0
  chr=' '
  if dchi le chi_cut[1] then chr='*'
  if dchi le chi_cut[0] then chr='o'
  print,dchi,chr,form='(F6.1,A1,$)'
endfor
print

end
   
;====================================================================

Pro Err2D,name,n,dn,chi_cut,j,form=form

common fitresults,par,epar,dof,xx,yy,dd

print,name+':'
print,form='(6x,$)'
for k=-n,n,dn do begin
  if keyword_set(form) then print,par[j[0]]+k*epar[j[0]],form=repstr(form[0],')',',$)') else print,k,form='(F6.1," ",$)'
endfor
print
chi0=total((fitprf(par,XVAL=xx,YVAL=yy,ERRVAL=dd))^2)
for k2=-n,n,dn do begin
  for k1=-n,n,dn do begin
    par1=par
    par1[j[0]]=par[j[0]]+k1*epar[j[0]]
    par1[j[1]]=par[j[1]]+k2*epar[j[1]]
    dchi=total( (fitprf(par1,XVAL=xx,YVAL=yy,ERRVAL=dd))^2)-chi0
    chr=' '
    if dchi le chi_cut[1] then chr='*'
    if dchi le chi_cut[0] then chr='o'
    print,dchi,chr,form='(F6.1,A1,$)'
  endfor
  if keyword_set(form) then print,par1[j[1]],form=form[1] else print,k2,form='(F6.1)'
endfor

end

;====================================================================

Pro Err3d,name,n,dn,chi_cut,j
    
common fitresults,par,epar,dof,xx,yy,dd

chi0=total((fitprf(par,XVAL=xx,YVAL=yy,ERRVAL=dd))^2)
m=long(2*n/float(dn))+1
dchi=dblarr(m,m,m)
p0=dchi
p1=dchi
p2=dchi
j0=0
for k0=-n,n,dn do begin
  print,(k0+n)/(2*n+1)*100,form='(I3.2,"%",$)'
  j1=0
  for k1=-n,n,dn do begin
    j2=0
    for k2=-n,n,dn do begin
      par1=par
      par1[j[0]]=par[j[0]]+k0*epar[j[0]]
      par1[j[1]]=par[j[1]]+k1*epar[j[1]]
      par1[j[2]]=par[j[2]]+k2*epar[j[2]]
      dchi[j0,j1,j2]=total((fitprf(par1,XVAL=xx,YVAL=yy,ERRVAL=dd))^2)-chi0
      p0[j0,j1,j2]=par1[j[0]]
      p1[j0,j1,j2]=par1[j[1]]
      p2[j0,j1,j2]=par1[j[2]]
      j2=j2+1
    endfor
    j1=j1+1
  endfor
  j0=j0+1
endfor
print

i1=where(dchi le chi_cut[0])
i2=where(dchi le chi_cut[1])
print,name[0],minmax(p0[i1]),minmax(p0[i2]),form='(A7,2I5,2x,2I5)'
print,name[1],minmax(p1[i1]),minmax(p1[i2]),form='(A7,2I5,2x,2I5)'
print,name[2],minmax(p2[i1]),minmax(p2[i2]),form='(A7,2I5,2x,2I5)'

;stop

end

;====================================================================

Pro GStokesEvent,event

common data,grid,fld,star,syn,obs,plt,fit
common fitresults,par,epar,dof,xx,yy,dd

Widget_Control,/hourglass
eventN=Widget_Info(event.id,/UNAME)
eventT=tag_names(event, /structure_name)
if eventT eq 'WIDGET_SLIDER' or eventT eq 'WIDGET_BUTTON' or $
   eventT eq 'WIDGET_TEXT_CH' or eventT eq 'WIDGET_DROPLIST' then Widget_Control,event.id,GET_VALUE = eventV

frecomp=1
frecomf=0
fredraw=1
case 1 of

; Field model and parameters
  eventN eq 'FMODE': begin   
    if event.index eq 4 then begin
      infile=dialog_pickfile(title='Select ascii file with magnetic map',filter='*.dat;*.txt')
      if strlen(infile) gt 0 then begin
        ss=' '
        openr,un,infile,/get_lun
        
        if strpos(infile,'.txt') ne -1 then begin
          ftmp=dblarr(4,star.ntot)
          readf,un,ftmp
          ftmp=ftmp[1:*,*]
          ftmp[1,*]=-ftmp[1,*]
        endif else begin
          ftmp=dblarr(3,star.ntot) & tmp=dblarr(star.ntot)
          for k=0,2 do begin
            readf,un,ss
            if strlen(strtrim(ss,2)) lt 1 then readf,un,ss
            readf,un,tmp
            ftmp[k,*]=tmp*1d3
          endfor
          ftmp[1,*]=-ftmp[1,*]
        endelse
        
        free_lun,un
        fld.btype=-1
        Widget_Control,Widget_Info(event.top,find_by_uname='SGRID'),sensitive=0

        b_local=dblarr(3)
        for i=0,star.ntot-1 do begin
          b_local[2]= ftmp[0,i]
          b_local[1]=-ftmp[1,i]
          b_local[0]= ftmp[2,i]
          fld.b0[*,i]=Transform(1,-grid.theta[i]/!dtor,-grid.phi[i]/!dtor,b_local)
        endfor

        eventV[n_elements(eventV)-1]=path2file(infile)
        Widget_Control,event.id,set_value=eventV,set_droplist_select=event.index
      endif
    endif else begin
      fld.btype=event.index
      if eventV[n_elements(eventV)-1] ne 'File' then begin
        eventV[n_elements(eventV)-1]='File'
        Widget_Control,event.id,set_value=eventV,set_droplist_select=event.index
        Widget_Control,Widget_Info(event.top,find_by_uname='SGRID'),sensitive=1
      endif
    endelse
    FldActive,fld.btype,event.top
    frecomf=1
  end
  (eventN eq 'FBD') or (eventN eq 'FBQ') or (eventN eq 'FBO') or (eventN eq 'FBET') or (eventN eq 'FPHI') or $
  (eventN eq 'FBET1') or (eventN eq 'FPHI1') or (eventN eq 'FDEC'): begin
    Widget_Control,Widget_Info(event.top,find_by_uname='FBD'),get_value=xval   & fld.bd=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='FBQ'),get_value=xval   & fld.bq=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='FBO'),get_value=xval   & fld.bo=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='FBET'),get_value=xval  & fld.beta=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='FPHI'),get_value=xval  & fld.phi=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='FBET1'),get_value=xval & fld.beta1=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='FPHI1'),get_value=xval & fld.phi1=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='FDEC'),get_value=xval  & fld.dec=double(xval)
    frecomf=1
  end
  
; Stellar parameters
  eventN eq 'SGRID': begin
    star.ntot=(long(eventV))[event.index]
    GridInit,star.ntot,grid
    CompFld,grid,fld
  end     
  (eventN eq 'SNPHA') or (eventN eq 'SINCL') or (eventN eq 'SVSIN') or (eventN eq 'SVRAD'): begin
    Widget_Control,Widget_Info(event.top,find_by_uname='SNPHA'),get_value=xval
    if long(xval) ne star.nphases then begin
      star.nphases=long(eventV)         
      star={vrange:star.vrange,vr:replicate(star.Vr[0],star.nphases),vstep:star.vstep,nphases:star.nphases, $
            fwhm:star.fwhm,vsini:star.vsini,d:replicate(star.d[0],star.nphases),limbd:star.limbd,betaME:star.betaME,incl:star.incl, $
            lambda0:star.lambda0,lande0:star.lande0,G0:star.G0,ltype:star.ltype,ntot:star.ntot}
    endif
    Widget_Control,Widget_Info(event.top,find_by_uname='SINCL'),get_value=xval & star.incl=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='SVSIN'),get_value=xval & star.vsini=double(xval)
    star.vrange=3d0*sqrt(star.vsini^2+star.fwhm^2)
    Widget_Control,Widget_Info(event.top,find_by_uname='SVRAD'),get_value=xval & star.vr[*]=double(xval)
  end

; Line model and parameters
  eventN eq 'LTYPE': begin
    star.ltype=event.index
    if event.index eq 0 then begin
      Widget_Control,Widget_Info(event.top,find_by_uname='CLIMB'),set_value='Limbd'
      Widget_Control,Widget_Info(event.top,find_by_uname='LLIMB'),set_value=string(star.limbd,form='(F6.3)')  
    endif else if event.index eq 1 then begin
      Widget_Control,Widget_Info(event.top,find_by_uname='CLIMB'),set_value='betME'
      Widget_Control,Widget_Info(event.top,find_by_uname='LLIMB'),set_value=string(star.betaME,form='(F6.3)')
    endif
  end  
  (eventN eq 'LDEPT') or (eventN eq 'LWIDT') or (eventN eq 'LLIMB') or (eventN eq 'LLAMB') or (eventN eq 'LLAND'): begin
    Widget_Control,Widget_Info(event.top,find_by_uname='LDEPT'),get_value=xval & star.d[*]=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='LWIDT'),get_value=xval & star.fwhm=double(xval)
    star.vrange=3d0*sqrt(star.vsini^2+star.fwhm^2)
    Widget_Control,Widget_Info(event.top,find_by_uname='LLIMB'),get_value=xval
    if star.ltype eq 0 then star.limbd=double(xval) else if star.ltype eq 1 then star.betaME=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='LLAMB'),get_value=xval & star.lambda0=double(xval)
    Widget_Control,Widget_Info(event.top,find_by_uname='LLAND'),get_value=xval & star.lande0=double(xval)
    star.G0=star.lande0^2
  end
  
; Plot parameters
  eventN eq 'FLDT': begin
    plt.fldt=Widget_Info(event.id,/button_set)
    frecomp=0
  end
  eventN eq 'FCOL': begin
    plt.fldb=Widget_Info(event.id,/button_set)
    frecomp=0
  end
  eventN eq 'SLIDI': begin
    plt.di=eventV/10.
    frecomp=0
  end
  eventN eq 'SLIDV': begin
    plt.dv=eventV/10.
    frecomp=0
  end
  eventN eq 'RTANG': begin
    plt.rtang=double(eventV)
    frecomp=0
  end
  eventN eq 'PDYN': begin
    plt.pdyn=Widget_Info(event.id,/button_set)
    Widget_Control,Widget_Info(event.top,find_by_uname='SLIDI'),sensitive=1-(plt.pdyn or plt.pbint)
    Widget_Control,Widget_Info(event.top,find_by_uname='SLIDV'),sensitive=1-(plt.pdyn or plt.pbint)
    frecomp=0
  end
  eventN eq 'PBIN': begin
    plt.pbint=Widget_Info(event.id,/button_set)
    Widget_Control,Widget_Info(event.top,find_by_uname='SLIDI'),sensitive=1-(plt.pdyn or plt.pbint)
    Widget_Control,Widget_Info(event.top,find_by_uname='SLIDV'),sensitive=1-(plt.pdyn or plt.pbint)
    Widget_Control,Widget_Info(event.top,find_by_uname='PDYN'),sensitive=1-plt.pbint
    frecomp=0
  end

; Fit parameters and flags
  eventN eq 'FIT_TYPE': begin
    fit.type=event.index
    if fit.type eq 0 then fit.flag[3:4]=0
    if fit.type eq 1 then fit.flag[0:2]=0
    Widget_Control,Widget_Info(event.top,find_by_uname='FIT_VSINI' ),set_button=fit.flag[0],sensitive=(fit.type ne 1)
    Widget_Control,Widget_Info(event.top,find_by_uname='FIT_VR'    ),set_button=fit.flag[1],sensitive=(fit.type ne 1)
    Widget_Control,Widget_Info(event.top,find_by_uname='FIT_LDEPTH'),set_button=fit.flag[2],sensitive=(fit.type ne 1)
    Widget_Control,Widget_Info(event.top,find_by_uname='FIT_INCL'  ),set_button=fit.flag[3],sensitive=(fit.type ge 1)
    Widget_Control,Widget_Info(event.top,find_by_uname='FIT_FIELD' ),set_button=fit.flag[4],sensitive=(fit.type ge 1)
  end
  eventN eq 'FIT_VSINI' : fit.flag[0]=event.select
  eventN eq 'FIT_VR'    : fit.flag[1]=event.select
  eventN eq 'FIT_LDEPTH': fit.flag[2]=event.select
  eventN eq 'FIT_INCL'  : fit.flag[3]=event.select
  eventN eq 'FIT_FIELD' : fit.flag[4]=event.select

; Running profile fit
  eventN eq 'RUN_FIT': begin
    npar=4+8
    parinfo=replicate({value:0.d0,fixed:1,tied:'',step:0d0},npar)
    parinfo[ 0].value=star.vsini  &  parinfo[ 0].step=0.1d0
    parinfo[ 1].value=star.vr[0]  &  parinfo[ 1].step=1d-3
    parinfo[ 2].value=star.d[0]   &  parinfo[ 2].step=1d-3
    parinfo[ 3].value=star.incl   ;&  parinfo[ 3].step=1d0
    parinfo[ 4].value=fld.Bd      ;&  parinfo[4:6].step=1d0
    parinfo[ 5].value=fld.Bq
    parinfo[ 6].value=fld.Bo
    parinfo[ 7].value=fld.dec     ;&  parinfo[7].step=1d-3
    parinfo[ 8].value=fld.beta    ;&  parinfo[8:11].step=1d0
    parinfo[ 9].value=fld.phi
    parinfo[10].value=fld.beta1
    parinfo[11].value=fld.phi1
    
    parinfo[0].fixed=(fit.flag[0] eq 0)
    parinfo[1].fixed=(fit.flag[1] eq 0)
    parinfo[2].fixed=(fit.flag[2] eq 0)
    parinfo[3].fixed=(fit.flag[3] eq 0)
    if fit.flag[4] then begin
      case fld.btype of
      0: parinfo[[4,8,9]].fixed=0
      1: parinfo[[4,7,8,9]].fixed=0
      2: parinfo[[4,5,6,8,9]].fixed=0
      3: parinfo[[4,5,8,9,10,11]].fixed=0
      endcase
    endif
    
    xx=reform(obs.v,n_elements(obs.v))
    if fit.type eq 0 then yy=reform(obs.prfI,n_elements(obs.prfI)) else $
    if fit.type eq 1 then yy=reform(obs.prfV,n_elements(obs.prfV))
    dd=reform(obs.prfE,n_elements(obs.prfE))

    par=MPFIT('fitprf',FUNCTARGS={XVAL:xx,YVAL:yy,ERRVAL:dd},$
      STATUS=status,NITER=niter,BESTNORM=bestnorm,PERROR=epar,$
      AUTODERIVATIVE=1,PARINFO=parinfo,quiet=1)

    ifree=where(parinfo.fixed eq 0,nfree)
    dof=n_elements(yy)-nfree
    epar=epar*sqrt(bestnorm/dof)

    print
    print,'----- Fit results -----'
    print,bestnorm/dof,sqrt(bestnorm/dof),form='("rChi^2, (rChi^2)^1/2 = ",2E10.3)'
    if fit.flag[0] then begin
      Widget_Control,Widget_Info(event.top,find_by_uname='SVSIN'),set_value=string(star.vsini,form='(F6.1)')
      print,par[0],epar[0],form='("Vsini =",F7.2,"+/-",F7.3)'
    endif
    if fit.flag[1] then begin
      Widget_Control,Widget_Info(event.top,find_by_uname='SVRAD'),set_value=string(star.vr[0],form='(F6.1)')
      print,par[1],epar[1],form='("Vr    =",F7.2,"+/-",F7.3)'
    endif
    if fit.flag[2] then begin
      Widget_Control,Widget_Info(event.top,find_by_uname='LDEPT'),set_value=string(star.d[0],form='(F5.2)')
      print,par[2],epar[2],form='("Depth =",F7.4,"+/-",F7.4)'
    endif
    if fit.flag[3] then begin
      Widget_Control,Widget_Info(event.top,find_by_uname='SINCL'),set_value=string(star.incl,form='(I5)')
      print,par[3],epar[3],form='("Incl  =",I5,"+/-",I5)'
    endif    
    if fit.flag[4] then begin
      Widget_Control,Widget_Info(event.top,find_by_uname='FBD'),set_value=string(fld.Bd,form='(I5)')
      print,par[4],epar[4],form='("Bd    =",I5,"+/-",I5)'
      if fld.btype eq 1 then begin
        Widget_Control,Widget_Info(event.top,find_by_uname='FDEC'),set_value=string(fld.dec,form='(F5.3)')
        print,par[7],epar[7],form='("Dec   =",I5,"+/-",I5)'
      endif
      if fld.btype eq 2 or fld.btype eq 3 then begin
        Widget_Control,Widget_Info(event.top,find_by_uname='FBQ'),set_value=string(fld.Bq,form='(I5)')
        print,par[5],epar[5],form='("Bq    =",I5,"+/-",I5)'
      endif
      if fld.btype eq 2 then begin
        Widget_Control,Widget_Info(event.top,find_by_uname='FBO'),set_value=string(fld.Bo,form='(I5)')
        print,par[6],epar[6],form='("Bo    =",I5,"+/-",I5)'
      endif
      Widget_Control,Widget_Info(event.top,find_by_uname='FBET'),set_value=string(fld.beta,form='(I5)')
      print,par[8],epar[8],form='("Beta  =",I5,"+/-",I5)'
      Widget_Control,Widget_Info(event.top,find_by_uname='FPHI'),set_value=string(fld.phi,form='(I5)')
      print,par[9],epar[9],form='("Phi   =",I5,"+/-",I5)'
      if fld.btype eq 3 then begin
        Widget_Control,Widget_Info(event.top,find_by_uname='FBET1'),set_value=string(fld.beta1,form='(I5)')
        print,par[10],epar[10],form='("Beta1 =",I5,"+/-",I5)'
        Widget_Control,Widget_Info(event.top,find_by_uname='FPHI1'),set_value=string(fld.phi1,form='(I5)')
        print,par[11],epar[11],form='("Phi1  =",I5,"+/-",I5)'
      endif
    endif

    ;Widget_Control,Widget_Info(event.top,find_by_uname='RUN_ERR'),sensitive=(max(fit.flag) ne 0 and fld.btype ne -1)
  end

; Performing error analysis
  eventN eq 'RUN_ERR': begin
    print
    print,'----- Error analysis -----'
    n=4.0
    dn=0.5  
    ;chi_cut=9.0  
    chi_prob=[0.682689492137d0,0.997300203937d0]    ; probabilities corresponding to 1 and 3 sigma of normal distribution

    ; for Vsini, Vr and line depth
    chi_cut=chi_prob*0d0
    for k=0,n_elements(chi_cut)-1 do chi_cut[k]=chisqr_cvf(1d0-chi_prob[k],1)
    if max(epar[0:2]) gt 0 then print,chi_cut,form='("chi^2 cuts for 1 and 3 sigma:",2F5.1)'
    if epar[0] gt 0 then err1d,'Vsini',n,dn,chi_cut,0
    if epar[1] gt 0 then err1d,'Vr'   ,n,dn,chi_cut,1
    if epar[2] gt 0 then err1d,'Depth',n,dn,chi_cut,2

    ; for pairs of Bd, beta, incl
    for k=0,n_elements(chi_cut)-1 do chi_cut[k]=chisqr_cvf(1d0-chi_prob[k],2)
    if max(epar[[3,4,8]]) then print,chi_cut,form='("chi^2 cuts for 1 and 3 sigma:",2F5.1)'
    if epar[4] gt 0 or epar[8] gt 0 then err2d,'Bd & beta',n,dn,chi_cut,[4,8],form=['(I7)','(I7)']
    if epar[4] gt 0 or epar[3] gt 0 then err2d,'Bd & incl',n,dn,chi_cut,[4,3],form=['(I7)','(I7)']
    if epar[8] gt 0 or epar[3] gt 0 then err2d,'beta & incl',n,dn,chi_cut,[8,3],form=['(I7)','(I7)']

    ; for triple of Bd, beta, incl
    for k=0,n_elements(chi_cut)-1 do chi_cut[k]=chisqr_cvf(1d0-chi_prob[k],3)
    if max(epar[[3,4,8]]) then begin
      print,chi_cut,form='("chi^2 cuts for 1 and 3 sigma:",2F5.1)'
      err3d,['incl','Bd','beta'],6.0,dn,chi_cut,[3,4,8]
    endif
  end

; Base and main buttons
  eventN eq 'TBAS': begin
     Widget_Control, event.id, Get_UValue=info, TLB_GET_SIZE=newSize
     wsz=floor(newSize[0]/2.)<newSize[1]
     Widget_Control, info.drawID, DRAW_XSIZE=wsz*2, DRAW_YSIZE=wsz
     plt.cscl=float(wsz)/info.wsz0
     info.wsz=wsz
     Widget_Control, event.top, Set_UValue=info, /No_Copy
     frecomp=0
  end
  eventN eq 'DONE': begin
     Widget_Control, event.top, /DESTROY
     return
  end  
  eventN eq 'SAVE': begin
     fld_sph=Fld2Sph(fld,grid)
     save,file=plt.outfile[0],syn,fld,fld_sph,star,grid,plt
     print,'GStokes: Data saved to '+plt.outfile[0]
     return
  end
else: return
endcase

if strpos(eventN,'FIT_') ne -1 then begin
  frecomp=0
  fredraw=0
  if obs.nphases gt 0 then begin
    Widget_Control,Widget_Info(event.top,find_by_uname='RUN_FIT'),sensitive=(max(fit.flag) ne 0 and fld.btype ne -1)
    ;Widget_Control,Widget_Info(event.top,find_by_uname='RUN_ERR'),sensitive=(max(fit.flag) ne 0 and fld.btype ne -1)
  endif
endif

if frecomf then CompFld,grid,fld                     ; recompute field if frecomf=1
if frecomp then begin                                ; recompute profiles if frecomp=1
  if obs.nphases gt 0 then $
    CompStokes,grid,fld.b,star,syn,phase=obs.phase,vv=obs.v,time=0 $      
  else $
    CompStokes,grid,fld.b,star,syn,time=0       
endif
if fredraw then GStokesDraw                         ; redraw

end

; ======================== MAIN PROGRAM STARTS HERE ========================

; A simple forward calculation of Stokes I and V profiles using 
; Gaussian local profiles and weak-field approximation

Pro GStokes                  , $
    saved=saved              , $     ; saved gstokes structure
    observations=observations, $     ; load observations
    compare=compare          , $     ; load gstokes structure for comparison
    phase=phase              , $     ; list of phases
    help=help

common data,grid,fld,star,syn,obs,plt,fit
common fitresults,par,epar,dof,xx,yy,dd

!quiet=1
!except=0
device,true_color=24,decomposed=0

; Print help
if keyword_set(help) then begin
  print,' GStokes [, saved=saved, obs=obs, compare=compare, phase=phase]'
  print,' phase  =phase           : use input array of phases for profile calculations'
  print,' saved  =''model.sav''     : load saved model parameters from a given IDL save file'
  print,' compare=''model.sav''     : overplot profiles/moments from a given IDL save file'
  print,' obs    =''obs.sav''       : load observational data from a given file'
  print,'   where ''obs.sav'' is an IDL save file containing the following tags'
  print,'             obs.nphases : number of rotation phases'
  print,'             obs.phase   : list of rotation phases'
  print,'             obs.v       : array of velocity values'
  print,'             obs.prfi    : 2-D array of Stokes I data [nphases, n_elements(obs.v)]'
  print,'             obs.prfv    : 2-D array of Stokes V data [nphases, n_elements(obs.v)]'  
  print,'             obs.prfe    : 2-D array of error bars [nphases, n_elements(obs.v)]'  
  return
endif

; Reading observations
if keyword_set(observations) then begin
  if size(observations,/type) eq 7 then begin
    f=findfile(observations,count=nf)
    if nf ne 1 then begin
      print,'GStokes: File with observations '+observations+' not found'
      return
    endif else begin
      print,'GStokes: Loding observations from '+observations
      restore,observations
    endelse
  endif else if size(observations,/type) eq 8 then begin
    tags=strupcase(tag_names(observations))
    i=where(strpos(tags,'NPHASES') ne -1,n1)
    i=where(strpos(tags,'V') ne -1,n2)
    i=where(strpos(tags,'PHASE') ne -1,n3)
    i=where(strpos(tags,'PRFI') ne -1,n4a)
    i=where(strpos(tags,'PRFV') ne -1,n4b)
    i=where(strpos(tags,'PRFE') ne -1,n4c)
    if n1+n2+n3 lt 3 or (n4a+n4b lt 1) or n4c lt 1 then begin
      print,'Invalid input observation structure'
      return
    endif else obs=observations
  endif
endif else obs={nphases:0}

; Starting from saved data
if keyword_set(saved) then begin
  if n_elements(file_search(saved)) ne 1 then begin
    print,'GStokes: Cannot locate data file '+saved
    return
  endif else begin
    print,'GStokes: Loding saved data from '+saved
    restore,saved
    fsaved=1
  endelse
endif else fsaved=0

; ================== Default parameters ==================

; star & magnetic field
ntot=1876l                          ; total number of surface elements
Bd=1000d0                           ; dipolar field strength
Bq=0d0                              ; duadrupolar field strength
Bo=0d0                              ; octupolar field strength
incl=60d0                           ; inclination angle
beta=90d0                           ; dipolar obliquity angle
phi=0d0                             ; dipolar phase angle
phi1=0d0                            ; quadrupolar phase angle
beta1=beta                          ; quadrupolar obliquity
btype=0                             ; JDL type=0, SB: type=1, decen dipole: type=2, numerical from file: type=-1
decenter=0d0                        ; decentering parameter for magnetic field
vsini=40d0                          ; projected rotational velocity

; line
fwhm=5d0                            ; FWHM of Gaussian profile in km/s
lande0=1.2d0                        ; effective lande factor
G0=lande0^2                         ; linear polarization sensitivity
lambda0=5000d0                      ; effective wavelength 
ldepth=0.5d0                        ; local line depth
limbd=0.5d0                         ; linear limb darkening coefficient
betaME=5d0                          ; ME beta parameter
ltype=0                             ; weak-field Gaussian ltype=0, ME Gaussian ltype=1

; velocity and time
Vr=0d0                              ; radial velocity
vrange=3d0*sqrt(vsini^2+fwhm^2)     ; range of velocities
vstep=1.0d0                         ; step of velocity grid
nphases=20                          ; number of equidistant rotation phases

; output IDL save file, ascii field file
outfile=['model.sav','field.dat']

; =====================================================

; Store stellar variables in structure
if not fsaved then $
star={vrange:vrange,vr:replicate(Vr,nphases),vstep:vstep,nphases:nphases, $
     fwhm:fwhm,vsini:vsini,d:replicate(ldepth,nphases),limbd:limbd,betaME:betaME,incl:incl, $
     lambda0:lambda0,lande0:lande0,G0:G0,ltype:ltype,ntot:ntot}

; Create initial structure for fitting
; [vsini,vr,ldepth,incl,field]
fit={type:0,flag:[0,0,0,0,0]}

; Inherit number of phases from observations if they are loaded
if obs.nphases gt 0 then star.nphases=obs.nphases

; Intialize surface grid
GridInit,star.ntot,grid

; Store initial magnetic field variables in structure
if not fsaved then $
fld={beta:beta,phi:phi,beta1:beta1,phi1:phi1,Bd:Bd,Bq:Bq,Bo:Bo,dec:decenter,btype:btype}

; Compute initial magnetic field
CompFld,grid,fld

; Create initial structure containing plotting parameters
if not keyword_set(compare) then compare=''
if not fsaved then $
plt={cscl:1.0,di:0.5,dv:0.5,outfile:outfile,compare:compare,fldt:1,fldb:1,rtang:0.,pdyn:0,pbint:0}

; Available surface grid sizes
ntot_choice=long([695,1176,1876,3909,8021,16082,33004])

; Compute Stokes I & V profiles
if obs.nphases gt 0 then $
  CompStokes,grid,fld.b,star,syn,phase=obs.phase,vv=obs.v $
else $
  CompStokes,grid,fld.b,star,syn

; create the widgets. Make sure the main base returns resize events
base=Widget_Base(/Column, Title='Magnetic field geometry and Stokes parameter profiles  Oleg Kochukhov (oleg.kochukhov@physics.uu.se)', UNAME='TBAS', /TLB_Size_Events, /Base_Align_Center)

; draw widget
device,get_screen_size=scr_size
wsz=fix(0.4*scr_size[0])
drawID=Widget_Draw(base, XSize=2*wsz, YSize=wsz, frame=3)

; default font for OSX and Linux depending on the the size of the screen
if !version.os eq 'darwin' or !version.os eq 'linux' then begin
  font=scr_size[0] lt 1200 ? '-misc-fixed-medium-r-semicondensed--12-90-100-100-c-60-iso8859-1' : $
  '-misc-fixed-bold-r-normal--13-120-75-75-c-80-iso8859-1'  
  WIDGET_CONTROL,DEFAULT_FONT=font
endif

; buttons base
base1=Widget_Base(base,/ROW,/ALIGN_CENTER)
baset=Widget_Tab(base1)

; field tab
baset10=Widget_Base(baset,title='Field',/row,/base_align_center)
baset1=Widget_Base(baset10,/row,/base_align_bottom,/frame)
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='Model', xsize=50, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='', xsize=30, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
list=Widget_Droplist(b0, VALUE=['Centered Bd','Decentered Bd','Axis Bd+Bq+Bo','Non-axis Bd+Bq','File'], UNAME='FMODE',/align_left)
Widget_Control,list,set_droplist_select=fld.btype
lbl=Widget_Label(b0, VALUE='', xsize=35, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='Bd', UNAME='FLBD', xsize=45, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='beta', UNAME='FLBET', xsize=45, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
txt=Widget_Text(b0, UNAME='FBD', VALUE=string(fld.bd,form='(I5)'), xsize=5, /edit,/align_left)
txt=Widget_Text(b0, UNAME='FBET', VALUE=string(fld.beta,form='(I5)'), xsize=5, /edit,/align_left)
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='Bq', UNAME='FLBQ', xsize=45, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='phi', UNAME='FLPHI', xsize=45, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
txt=Widget_Text(b0, UNAME='FBQ', VALUE=string(fld.bq,form='(I5)'), xsize=5, /edit,/align_left)
txt=Widget_Text(b0, UNAME='FPHI', VALUE=string(fld.phi,form='(I5)'), xsize=5, /edit,/align_left)
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='Bo', UNAME='FLBO', xsize=45, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='beta1', UNAME='FLBET1', xsize=45, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
txt=Widget_Text(b0, UNAME='FBO', VALUE=string(fld.bo,form='(I5)'), xsize=5, /edit,/align_left)
txt=Widget_Text(b0, UNAME='FBET1', VALUE=string(fld.beta1,form='(I5)'), xsize=5, /edit,/align_left)
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='Dec', UNAME='FLDEC', xsize=45, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='phi1', UNAME='FLPHI1', xsize=45, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
txt=Widget_Text(b0, UNAME='FDEC', VALUE=string(fld.dec,form='(F5.3)'), xsize=5, /edit,/align_left)
txt=Widget_Text(b0, UNAME='FPHI1', VALUE=string(fld.phi1,form='(I5)'), xsize=5, /edit,/align_left)
FldActive,fld.btype,base

; star tab
baset10=Widget_Base(baset,title='Star',/row,/base_align_center)
baset1=Widget_Base(baset10,/row,/base_align_bottom,/frame)
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='Grid', xsize=50, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='', xsize=50, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
list=Widget_Droplist(b0, VALUE=strtrim(ntot_choice,2), UNAME='SGRID',/align_left)
Widget_Control,list,set_droplist_select=where(ntot_choice eq star.ntot)
lbl=Widget_Label(b0, VALUE='', xsize=50, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='Nphase', xsize=50, ysize=30, /align_right)
if obs.nphases gt 0 then Widget_Control,lbl,sensitive=0
lbl=Widget_Label(b0, VALUE='Incl', xsize=50, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
txt=Widget_Text(b0, UNAME='SNPHA', VALUE=string(star.nphases,form='(I5)'), xsize=5, /edit,/align_left)
if obs.nphases gt 0 then Widget_Control,txt,sensitive=0
txt=Widget_Text(b0, UNAME='SINCL', VALUE=string(star.incl,form='(I5)'), xsize=5, /edit,/align_left)
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='Vsini', xsize=50, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='Vr', xsize=50, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
txt=Widget_Text(b0, UNAME='SVSIN', VALUE=string(star.vsini,form='(F6.1)'), xsize=6, /edit,/align_left)
txt=Widget_Text(b0, UNAME='SVRAD', VALUE=string(star.vr,form='(F6.1)'), xsize=6, /edit,/align_left)

; line tab
baset10=Widget_Base(baset,title='Line',/row,/base_align_center)
baset1=Widget_Base(baset10,/row,/base_align_bottom,/frame)
b0=Widget_Base(baset1,/column)
list=Widget_Droplist(b0, VALUE=['Gaussian WF','Gaussian ME'], UNAME='LTYPE', /align_right)
Widget_Control,list,set_droplist_select=star.ltype
b1=Widget_Base(b0,/row)
if star.ltype eq 0 then begin
  lbl=Widget_Label(b1, UNAME='CLIMB', VALUE='Limbd', xsize=60, ysize=30, /align_right)
  txt=Widget_Text(b1, UNAME='LLIMB', VALUE=string(star.limbd,form='(F6.3)'), xsize=5, /edit, /align_right)
endif else if star.ltype eq 1 then begin
  lbl=Widget_Label(b1, UNAME='CLIMB', VALUE='betME', xsize=60, ysize=30, /align_right)
  txt=Widget_Text(b1, UNAME='LLIMB', VALUE=string(star.betaME,form='(F6.3)'), xsize=5, /edit, /align_right)
endif
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='Depth', xsize=60, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='Lambda', xsize=60, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
txt=Widget_Text(b0, UNAME='LDEPT', VALUE=string(star.d[0],form='(F5.2)'), xsize=5, /edit, /align_right)
txt=Widget_Text(b0, UNAME='LLAMB', VALUE=string(star.lambda0,form='(I5)'), xsize=5, /edit, /align_right)
b0=Widget_Base(baset1,/column)
lbl=Widget_Label(b0, VALUE='FWHM', xsize=60, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='Lande', xsize=60, ysize=30, /align_right)
b0=Widget_Base(baset1,/column)
txt=Widget_Text(b0, UNAME='LWIDT', VALUE=string(star.fwhm,form='(F6.2)'), xsize=5, /edit, /align_right)
txt=Widget_Text(b0, UNAME='LLAND', VALUE=string(star.lande0,form='(F6.3)'), xsize=5, /edit, /align_right)

; plot tab
baset10=Widget_Base(baset,title='Plot',/row,/base_align_center)
baset2=Widget_Base(baset10,/row,/base_align_bottom,/frame)
b0=Widget_Base(baset2,/COLUMN,/align_left)
b1=Widget_Base(b0,/ROW,/ALIGN_LEFT,/BASE_ALIGN_BOTTOM)
lbl=Widget_Label(b1, VALUE='I scale')
slid=Widget_Slider(b1, UNAME='SLIDI', min=0.1*10, max=2.0*10, VALUE=plt.di*10, xsize=130)

bb1=Widget_Base(b1,/row,/ALIGN_BOTTOM,/BASE_ALIGN_BOTTOM,/nonexclusive)
but=Widget_Button(bb1, VALUE='Fld 4', UNAME='FLDT',/align_right)
Widget_Control,but,set_button=plt.fldt
but=Widget_Button(bb1, VALUE='Sph', UNAME='FCOL',/align_right)
Widget_Control,but,set_button=plt.fldb
but=Widget_Button(bb1, VALUE='Dyn', UNAME='PDYN',/align_right)
Widget_Control,but,set_button=plt.pdyn

b2=Widget_Base(b0,/ROW,/ALIGN_left,/BASE_ALIGN_BOTTOM)
lbl=Widget_Label(b2, VALUE='V scale')
slid=Widget_Slider(b2, UNAME='SLIDV', min=0.1*10, max=2.0*10, VALUE=plt.dv*10, xsize=130)
lbl=Widget_Label(b2, VALUE='Rot Ang', ysize=30, /align_right)
txt=Widget_Text(b2, UNAME='RTANG', VALUE=string(plt.rtang,form='(I4)'), xsize=4, /edit, /align_left)
bb1=Widget_Base(b2,/row,/ALIGN_CENTER,/BASE_ALIGN_CENTER,/nonexclusive)
but=Widget_Button(bb1, VALUE='Bint', UNAME='PBIN',/align_right)
Widget_Control,but,set_button=plt.pbint

; fit tab
baset10=Widget_Base(baset,title='Fit',/row,/base_align_center)
baset3=Widget_Base(baset10,/row,/base_align_bottom,/frame)
b0=Widget_Base(baset3,/column)
lbl=Widget_Label(b0, VALUE='Stokes', xsize=50, ysize=30, /align_right)
lbl=Widget_Label(b0, VALUE='', xsize=50, ysize=30, /align_right)
b0=Widget_Base(baset3,/column)
;list=Widget_Droplist(b0, VALUE=[' I ',' V ',' IV'], UNAME='FIT_TYPE',/align_left)
list=Widget_Droplist(b0, VALUE=[' I ',' V '], UNAME='FIT_TYPE',/align_left)
Widget_Control,list,set_droplist_select=fit.type
lbl=Widget_Label(b0, VALUE='', xsize=50, ysize=30, /align_right)

b0=Widget_Base(baset3,/column,/nonexclusive,/align_left,/align_top)
but=Widget_Button(b0, VALUE='Vsini', UNAME='FIT_VSINI', ysize=30)
Widget_Control,but,set_button=fit.flag[0],sensitive=(fit.type ne 1)
but=Widget_Button(b0, VALUE='Vr', UNAME='FIT_VR', ysize=30)
Widget_Control,but,set_button=fit.flag[1],sensitive=(fit.type ne 1)

b0=Widget_Base(baset3,/column,/nonexclusive,/align_left,/align_top)
but=Widget_Button(b0, VALUE='Depth', UNAME='FIT_LDEPTH', ysize=30)
Widget_Control,but,set_button=fit.flag[2],sensitive=(fit.type ne 1)
but=Widget_Button(b0, VALUE='Incl', UNAME='FIT_INCL', ysize=30)
Widget_Control,but,set_button=fit.flag[3],sensitive=(fit.type ge 1)

b0=Widget_Base(baset3,/column,/nonexclusive,/align_left,/align_top)
but=Widget_Button(b0, VALUE='Field', UNAME='FIT_FIELD', ysize=30)
Widget_Control,but,set_button=fit.flag[4],sensitive=(fit.type ge 1)

b0=Widget_Base(baset3,/column,/align_center)
but=Widget_Button(b0, VALUE = ' Fit profiles ', UNAME = 'RUN_FIT', ysize=30)
Widget_Control,but,sensitive=(max(fit.flag) ne 0)
but=Widget_Button(b0, VALUE = ' Error analysis ', UNAME = 'RUN_ERR', ysize=30)
Widget_Control,but,sensitive=0

; last buttons
base2=Widget_Base(base1,/COLUMN,/ALIGN_BOTTOM)
outp=Widget_Button(base2, VALUE = ' SAVE ', UNAME = 'SAVE')
done=Widget_Button(base2, VALUE = ' QUIT ', UNAME = 'DONE')

; Realize the widgets
Widget_Control, base, /Realize

; Get the window index number. Make it current.
Widget_Control, drawID, Get_Value=wind
WSet, wind

; Display the data
GStokesDraw

; Create an info structure and store it.
info = {wind:wind, drawID:drawID, wsz:wsz, wsz0:wsz}
Widget_Control, base, Set_UValue=info, /No_Copy

; Set up XManager
XManager,'gstokes',base,Event_Handler='GStokesEvent',/No_Block

end
